/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.ClaimsRequest;
import com.microsoft.aad.msal4j.IApiParameters;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import java.util.Set;
import lombok.NonNull;

public class IntegratedWindowsAuthenticationParameters
implements IApiParameters {
    @NonNull
    private Set<String> scopes;
    private ClaimsRequest claims;
    @NonNull
    private String username;

    private static IntegratedWindowsAuthenticationParametersBuilder builder() {
        return new IntegratedWindowsAuthenticationParametersBuilder();
    }

    public static IntegratedWindowsAuthenticationParametersBuilder builder(Set<String> scopes, String username) {
        ParameterValidationUtils.validateNotEmpty("scopes", scopes);
        ParameterValidationUtils.validateNotBlank("username", username);
        return IntegratedWindowsAuthenticationParameters.builder().scopes(scopes).username(username);
    }

    @Override
    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    @Override
    public ClaimsRequest claims() {
        return this.claims;
    }

    @NonNull
    public String username() {
        return this.username;
    }

    private IntegratedWindowsAuthenticationParameters(@NonNull Set<String> scopes, ClaimsRequest claims, @NonNull String username) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.claims = claims;
        this.username = username;
    }

    public static class IntegratedWindowsAuthenticationParametersBuilder {
        private Set<String> scopes;
        private ClaimsRequest claims;
        private String username;

        IntegratedWindowsAuthenticationParametersBuilder() {
        }

        public IntegratedWindowsAuthenticationParametersBuilder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public IntegratedWindowsAuthenticationParametersBuilder claims(ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        public IntegratedWindowsAuthenticationParametersBuilder username(String username) {
            this.username = username;
            return this;
        }

        public IntegratedWindowsAuthenticationParameters build() {
            return new IntegratedWindowsAuthenticationParameters(this.scopes, this.claims, this.username);
        }

        public String toString() {
            return "IntegratedWindowsAuthenticationParameters.IntegratedWindowsAuthenticationParametersBuilder(scopes=" + this.scopes + ", claims=" + this.claims + ", username=" + this.username + ")";
        }
    }
}

