// Generated by delombok at Fri Feb 12 21:32:09 UTC 2021
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotBlank;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotEmpty;

/**
 * Object containing parameters for Username/Password flow. Can be used as parameter to

 * {@link PublicClientApplication#acquireToken(UserNamePasswordParameters)}

 *

 * For more details, see https://aka.ms/msal4j-username-password
 */
public class UserNamePasswordParameters implements IApiParameters {
    /**
     * Scopes application is requesting access to
     */
    @NonNull
    private Set<String> scopes;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;
    /**
     * Username of the account
     */
    @NonNull
    private String username;
    /**
     * Char array containing credentials for the username
     */
    @NonNull
    private char[] password;

    public char[] password() {
        return password.clone();
    }

    private static UserNamePasswordParametersBuilder builder() {
        return new UserNamePasswordParametersBuilder();
    }

    /**
     * Builder for UserNameParameters

     * @param scopes scopes application is requesting access to

     * @param username username of the account

     * @param password char array containing credentials for the username

     * @return builder object that can be used to construct UserNameParameters
     */
    public static UserNamePasswordParametersBuilder builder(Set<String> scopes, String username, char[] password) {
        validateNotEmpty("scopes", scopes);
        validateNotBlank("username", username);
        validateNotEmpty("password", password);
        return builder().scopes(scopes).username(username).password(password);
    }


    public static class UserNamePasswordParametersBuilder {
        @java.lang.SuppressWarnings("all")
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        private String username;
        @java.lang.SuppressWarnings("all")
        private char[] password;

        public UserNamePasswordParametersBuilder password(char[] password) {
            this.password = password.clone();
            return this;
        }

        @java.lang.SuppressWarnings("all")
        UserNamePasswordParametersBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        public UserNamePasswordParametersBuilder scopes(final Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public UserNamePasswordParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public UserNamePasswordParametersBuilder username(final String username) {
            this.username = username;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        public UserNamePasswordParameters build() {
            return new UserNamePasswordParameters(scopes, claims, username, password);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "UserNamePasswordParameters.UserNamePasswordParametersBuilder(scopes=" + this.scopes + ", claims=" + this.claims + ", username=" + this.username + ", password=" + java.util.Arrays.toString(this.password) + ")";
        }
    }

    /**
     * Scopes application is requesting access to
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Username of the account
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    public String username() {
        return this.username;
    }

    @java.lang.SuppressWarnings("all")
    private UserNamePasswordParameters(@NonNull final Set<String> scopes, final ClaimsRequest claims, @NonNull final String username, @NonNull final char[] password) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked @NonNull but is null");
        }
        if (username == null) {
            throw new java.lang.NullPointerException("username is marked @NonNull but is null");
        }
        if (password == null) {
            throw new java.lang.NullPointerException("password is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.claims = claims;
        this.username = username;
        this.password = password;
    }
}
