/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.DeviceTwin;

import com.microsoft.azure.sdk.iot.device.DeviceTwin.Pair;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.Property;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.PropertyCallBack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class Device
implements PropertyCallBack<String, Object> {
    private HashSet<Property> reportedProp = new HashSet();
    private HashMap<Property, Pair<PropertyCallBack<String, Object>, Object>> desiredProp = new HashMap();

    public HashSet<Property> getReportedProp() {
        return this.reportedProp;
    }

    public void setReportedProp(Property reportedProp) {
        if (reportedProp == null) {
            throw new IllegalArgumentException("Reported property cannot be null");
        }
        Property duplicateProperty = null;
        for (Property property : this.reportedProp) {
            if (!property.getKey().equalsIgnoreCase(reportedProp.getKey())) continue;
            duplicateProperty = property;
        }
        if (duplicateProperty != null) {
            this.reportedProp.remove(duplicateProperty);
        }
        this.reportedProp.add(reportedProp);
    }

    public HashMap<Property, Pair<PropertyCallBack<String, Object>, Object>> getDesiredProp() {
        return this.desiredProp;
    }

    public void setDesiredPropertyCallback(Property desiredProp, PropertyCallBack<String, Object> desiredPropCallBack, Object desiredPropCallBackContext) {
        if (desiredProp == null) {
            throw new IllegalArgumentException("desired property cannot be null");
        }
        this.desiredProp.put(desiredProp, new Pair<PropertyCallBack<String, Object>, Object>(desiredPropCallBack, desiredPropCallBackContext));
    }

    public void clean() {
        if (this.reportedProp != null) {
            Iterator<Property> repProperty = this.reportedProp.iterator();
            while (repProperty.hasNext()) {
                repProperty.next();
                repProperty.remove();
            }
        }
        if (this.desiredProp != null) {
            Iterator<Map.Entry<Property, Pair<PropertyCallBack<String, Object>, Object>>> desiredProperty = this.desiredProp.entrySet().iterator();
            while (desiredProperty.hasNext()) {
                desiredProperty.next();
                desiredProperty.remove();
            }
        }
    }
}

