/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import java.net.InetSocketAddress;
import java.net.Proxy;

public class ProxySettings {
    private Proxy proxy;
    private String username;
    private char[] password;

    public ProxySettings(Proxy proxy, String username, char[] password) {
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy cannot be null");
        }
        if (proxy.type() == Proxy.Type.DIRECT) {
            throw new IllegalArgumentException("Proxy settings cannot be configured to be DIRECT");
        }
        this.proxy = proxy;
        if (username != null && username.isEmpty()) {
            throw new IllegalArgumentException("Username cannot be an empty string");
        }
        if (password != null && password.length == 0) {
            throw new IllegalArgumentException("Password cannot be an empty string");
        }
        this.username = username;
        this.password = password;
    }

    public ProxySettings(Proxy proxy) {
        this(proxy, null, null);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getHostname() {
        if (this.proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)this.proxy.address();
            return addr.getHostName();
        }
        throw new UnsupportedOperationException("Could not get port from saved proxy");
    }

    public int getPort() {
        if (this.proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)this.proxy.address();
            return addr.getPort();
        }
        throw new UnsupportedOperationException("Could not get port from saved proxy");
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }
}

