/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.fileupload;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.fileupload.FileUploadInProgress;
import com.microsoft.azure.sdk.iot.device.fileupload.FileUploadTask;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsTransportManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUpload {
    private static final Logger log = LoggerFactory.getLogger(FileUpload.class);
    private static final int MAX_UPLOAD_PARALLEL = 10;
    private HttpsTransportManager httpsTransportManager;
    private ScheduledExecutorService taskScheduler;
    private FileUploadStatusCallBack fileUploadStatusCallBack;
    private static Queue<FileUploadInProgress> fileUploadInProgressesSet;

    public FileUpload(DeviceClientConfig config) throws IllegalArgumentException, IOException {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        this.httpsTransportManager = new HttpsTransportManager(config);
        try {
            this.taskScheduler = Executors.newScheduledThreadPool(10);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IOException("Cannot create a pool of threads to manager uploads: " + e);
        }
        fileUploadInProgressesSet = new LinkedBlockingDeque<FileUploadInProgress>();
        this.fileUploadStatusCallBack = new FileUploadStatusCallBack();
        log.info("FileUpload object is created successfully");
    }

    public synchronized void uploadToBlobAsync(String blobName, InputStream inputStream, long streamLength, IotHubEventCallback statusCallback, Object statusCallbackContext) throws IllegalArgumentException, IOException {
        if (blobName == null || blobName.isEmpty()) {
            throw new IllegalArgumentException("blobName is null or empty");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        if (streamLength < 0L) {
            throw new IllegalArgumentException("streamLength is negative");
        }
        if (statusCallback == null) {
            throw new IllegalArgumentException("statusCallback is null");
        }
        FileUploadInProgress newUpload = new FileUploadInProgress(statusCallback, statusCallbackContext);
        fileUploadInProgressesSet.add(newUpload);
        FileUploadTask fileUploadTask = new FileUploadTask(blobName, inputStream, streamLength, this.httpsTransportManager, this.fileUploadStatusCallBack, newUpload);
        newUpload.setTask(this.taskScheduler.submit(fileUploadTask));
    }

    public void closeNow() throws IOException {
        this.taskScheduler.shutdownNow();
        for (FileUploadInProgress uploadInProgress : fileUploadInProgressesSet) {
            if (!uploadInProgress.isCancelled()) continue;
            uploadInProgress.triggerCallback(IotHubStatusCode.ERROR);
        }
    }

    private final class FileUploadStatusCallBack
    implements IotHubEventCallback {
        private FileUploadStatusCallBack() {
        }

        @Override
        public synchronized void execute(IotHubStatusCode status, Object context) {
            if (context instanceof FileUploadInProgress) {
                FileUploadInProgress uploadInProgress = (FileUploadInProgress)context;
                uploadInProgress.triggerCallback(status);
                try {
                    fileUploadInProgressesSet.remove(context);
                }
                catch (ClassCastException | NullPointerException | UnsupportedOperationException e) {
                    log.error("FileUploadStatusCallBack received callback for unknown FileUpload", (Throwable)e);
                }
            } else {
                log.error("FileUploadStatusCallBack received callback for unknown FileUpload");
            }
        }
    }
}

