/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.net;

import com.microsoft.azure.sdk.iot.device.net.IotHubUri;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class IotHubRejectUri {
    private static final String REJECT_PATH_FORMAT = "/messages/devicebound/%s";
    private static final Map<String, String> REJECT_QUERY_PARAM;
    private final IotHubUri uri;

    public IotHubRejectUri(String iotHubHostname, String deviceId, String eTag, String moduleId) {
        String rejectPath = String.format(REJECT_PATH_FORMAT, eTag);
        this.uri = new IotHubUri(iotHubHostname, deviceId, rejectPath, REJECT_QUERY_PARAM, moduleId);
    }

    public String toString() {
        return this.uri.toString();
    }

    public String getHostname() {
        return this.uri.getHostname();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    protected IotHubRejectUri() {
        this.uri = null;
    }

    static {
        HashMap<String, String> rejectQueryParam = new HashMap<String, String>();
        rejectQueryParam.put("?reject", "true");
        REJECT_QUERY_PARAM = Collections.unmodifiableMap(rejectQueryParam);
    }
}

