/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.ProxySettings;
import com.microsoft.azure.sdk.iot.device.transport.ProxiedSSLSocket;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;

public class HttpProxySocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory delegate;
    private final ProxySettings proxySettings;

    @Override
    public Socket createSocket() throws IOException {
        Socket proxySocket = new Socket(this.proxySettings.getHostname(), this.proxySettings.getPort());
        return new ProxiedSSLSocket(this.delegate, proxySocket, this.proxySettings.getUsername(), this.proxySettings.getPassword());
    }

    public HttpProxySocketFactory(SSLSocketFactory delegate, ProxySettings proxySettings) {
        this.delegate = delegate;
        this.proxySettings = proxySettings;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket arg0, String arg1, int arg2, boolean arg3) throws IOException {
        return this.delegate.createSocket(arg0, arg1, arg2, arg3);
    }

    @Override
    public Socket createSocket(Socket arg0, InputStream arg1, boolean arg2) throws IOException {
        return this.delegate.createSocket(arg0, arg1, arg2);
    }

    @Override
    public Socket createSocket(String arg0, int arg1) throws IOException, UnknownHostException {
        return this.delegate.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException, UnknownHostException {
        return this.delegate.createSocket(arg0, arg1, arg2, arg3);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
        return this.delegate.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        return this.delegate.createSocket(arg0, arg1, arg2, arg3);
    }

    private static interface SSLSocketFactoryNonDelegatedFunctions {
        public Socket createSocket();
    }
}

