/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IotHubReceiveTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(IotHubReceiveTask.class);
    private static final String THREAD_NAME = "azure-iot-sdk-IotHubReceiveTask";
    private final IotHubTransport transport;
    private final Object receiveThreadLock;

    public IotHubReceiveTask(IotHubTransport transport) {
        if (transport == null) {
            throw new IllegalArgumentException("Parameter 'transport' must not be null");
        }
        this.transport = transport;
        this.receiveThreadLock = this.transport.getReceiveThreadLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName(THREAD_NAME);
        try {
            if (this.transport.getProtocol() != IotHubClientProtocol.HTTPS) {
                Object object = this.receiveThreadLock;
                synchronized (object) {
                    if (!this.transport.hasReceivedMessagesToHandle() && !this.transport.isClosed()) {
                        this.receiveThreadLock.wait();
                    }
                }
            }
            this.transport.handleMessage();
        }
        catch (Throwable e) {
            log.warn("Receive task thread encountered exception while processing received messages", e);
        }
    }
}

