/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsLinkStateCallback;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsReceiverLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AuthenticationMessageCallback;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AmqpsCbsReceiverLinkHandler
extends AmqpsReceiverLinkHandler {
    private static final Logger log = LoggerFactory.getLogger(AmqpsCbsReceiverLinkHandler.class);
    private static final String APPLICATION_PROPERTY_STATUS_CODE = "status-code";
    private static final String APPLICATION_PROPERTY_STATUS_DESCRIPTION = "status-description";
    private static final String RECEIVER_LINK_ENDPOINT_PATH = "$cbs";
    private static final String RECEIVER_LINK_TAG_PREFIX = "cbs-receiver";
    private static final String LINK_TYPE = "cbs";
    private Map<UUID, AuthenticationMessageCallback> correlationMap = new ConcurrentHashMap<UUID, AuthenticationMessageCallback>();

    AmqpsCbsReceiverLinkHandler(Receiver receiver, AmqpsLinkStateCallback amqpsLinkStateCallback) {
        super(receiver, amqpsLinkStateCallback, UUID.randomUUID().toString());
        this.receiverLinkTag = RECEIVER_LINK_TAG_PREFIX;
        this.receiverLinkAddress = RECEIVER_LINK_ENDPOINT_PATH;
    }

    static String getCbsTag() {
        return RECEIVER_LINK_TAG_PREFIX;
    }

    @Override
    public String getLinkInstanceType() {
        return LINK_TYPE;
    }

    @Override
    public void onDelivery(Event event) {
        Receiver receiverLink = (Receiver)event.getLink();
        Delivery delivery = event.getDelivery();
        log.trace("Received a message on the CBS receiver link");
        this.handleCBSResponseMessage(receiverLink);
        delivery.free();
    }

    private void handleCBSResponseMessage(Receiver receiver) {
        AmqpsMessage amqpsMessage = super.getMessageFromReceiverLink(receiver);
        if (amqpsMessage != null) {
            if (amqpsMessage.getApplicationProperties() != null && amqpsMessage.getProperties() != null) {
                Properties properties = amqpsMessage.getProperties();
                Object correlationId = properties.getCorrelationId();
                Map applicationProperties = amqpsMessage.getApplicationProperties().getValue();
                if (!this.correlationMap.containsKey(correlationId)) {
                    log.error("Received cbs authentication message with no correlation id. Ignoring it...");
                    amqpsMessage.acknowledge((DeliveryState)Released.getInstance());
                    return;
                }
                AuthenticationMessageCallback authenticationMessageCallback = this.correlationMap.remove(correlationId);
                for (Map.Entry entry : applicationProperties.entrySet()) {
                    String propertyKey = (String)entry.getKey();
                    if (!propertyKey.equals(APPLICATION_PROPERTY_STATUS_CODE) || !(entry.getValue() instanceof Integer)) continue;
                    int authenticationResponseCode = (Integer)entry.getValue();
                    String statusDescription = "";
                    if (applicationProperties.containsKey(APPLICATION_PROPERTY_STATUS_DESCRIPTION)) {
                        statusDescription = (String)applicationProperties.get(APPLICATION_PROPERTY_STATUS_DESCRIPTION);
                    }
                    DeliveryState ackType = authenticationMessageCallback.handleAuthenticationResponseMessage(authenticationResponseCode, statusDescription);
                    amqpsMessage.acknowledge(ackType);
                    return;
                }
            } else {
                log.warn("Could not handle authentication message because it had no application properties or had no system properties");
            }
        }
        if (amqpsMessage != null) {
            amqpsMessage.acknowledge((DeliveryState)Released.getInstance());
        }
    }

    void addAuthenticationMessageCorrelation(UUID correlationId, AuthenticationMessageCallback authenticationMessageCallback) {
        this.correlationMap.put(correlationId, authenticationMessageCallback);
    }
}

