/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsCbsReceiverLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsCbsSenderLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsLinkStateCallback;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsReceiverLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSenderLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSessionStateCallback;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AuthenticationMessageCallback;
import java.util.UUID;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpsCbsSessionHandler
extends BaseHandler
implements AmqpsLinkStateCallback {
    private static final Logger log = LoggerFactory.getLogger(AmqpsCbsSessionHandler.class);
    private Session session;
    private AmqpsCbsSenderLinkHandler cbsSenderLinkHandler;
    private AmqpsCbsReceiverLinkHandler cbsReceiverLinkHandler;
    private AmqpsSessionStateCallback connectionStateCallback;
    private boolean senderOpened;
    private boolean receiverOpened;

    AmqpsCbsSessionHandler(Session session, AmqpsSessionStateCallback connectionStateCallback) {
        this.session = session;
        this.connectionStateCallback = connectionStateCallback;
        this.senderOpened = false;
        this.receiverOpened = false;
        BaseHandler.setHandler((Extendable)this.session, (Handler)this);
        this.session.open();
    }

    public void onSessionLocalOpen(Event event) {
        log.debug("Opening Cbs session handler");
        this.session = event.getSession();
        Sender cbsSender = this.session.sender(AmqpsCbsSenderLinkHandler.getCbsTag());
        Receiver cbsReceiver = this.session.receiver(AmqpsCbsReceiverLinkHandler.getCbsTag());
        this.cbsSenderLinkHandler = new AmqpsCbsSenderLinkHandler(cbsSender, this);
        this.cbsReceiverLinkHandler = new AmqpsCbsReceiverLinkHandler(cbsReceiver, this);
    }

    public void onSessionRemoteOpen(Event e) {
        log.trace("CBS session opened remotely");
    }

    public void onSessionLocalClose(Event e) {
        log.trace("CBS session closed remotely");
        this.session.getConnection().close();
        this.cbsSenderLinkHandler.close();
        this.cbsReceiverLinkHandler.close();
    }

    public void onSessionRemoteClose(Event e) {
        Session session = e.getSession();
        if (session.getLocalState() == EndpointState.ACTIVE) {
            log.debug("Amqp CBS session closed remotely unexpectedly");
            this.connectionStateCallback.onSessionClosedUnexpectedly(session.getRemoteCondition());
            this.session.close();
        } else {
            log.trace("Amqp CBS session closed remotely as expected");
        }
    }

    public void sendAuthenticationMessage(DeviceClientConfig deviceClientConfig, AuthenticationMessageCallback authenticationMessageCallback) throws TransportException {
        UUID correlationId = this.cbsSenderLinkHandler.sendAuthenticationMessage(deviceClientConfig);
        this.cbsReceiverLinkHandler.addAuthenticationMessageCorrelation(correlationId, authenticationMessageCallback);
    }

    @Override
    public void onLinkOpened(BaseHandler linkHandler) {
        if (linkHandler instanceof AmqpsSenderLinkHandler) {
            this.senderOpened = true;
        } else if (linkHandler instanceof AmqpsReceiverLinkHandler) {
            this.receiverOpened = true;
        }
        if (this.senderOpened && this.receiverOpened) {
            log.trace("CBS session opened successfully, notifying connection layer to start sending authentication messages");
            this.connectionStateCallback.onAuthenticationSessionOpened();
        }
    }

    @Override
    public void onMessageAcknowledged(Message message, int deliveryTag) {
    }

    @Override
    public void onMessageReceived(IotHubTransportMessage message) {
        this.connectionStateCallback.onMessageReceived(message);
    }

    @Override
    public void onLinkClosedUnexpectedly(ErrorCondition errorCondition) {
        log.trace("CBS link closed unexpectedly, closing the CBS session");
        this.session.close();
        this.connectionStateCallback.onSessionClosedUnexpectedly(errorCondition);
    }

    public void onAuthenticationFailed(TransportException transportException) {
        this.connectionStateCallback.onAuthenticationFailed(transportException);
    }

    public void close() {
        log.trace("Closing this CBS session");
        this.session.close();
    }
}

