/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsLinkStateCallback;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSenderLinkHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.impl.MessageImpl;

public final class AmqpsMethodsSenderLinkHandler
extends AmqpsSenderLinkHandler {
    private static final String CORRELATION_ID_KEY = "com.microsoft:channel-correlation-id";
    private static final String CORRELATION_ID_KEY_PREFIX = "methods:";
    private static final String APPLICATION_PROPERTY_KEY_IOTHUB_STATUS = "IoThub-status";
    private static final String DEVICE_SENDER_LINK_ENDPOINT_PATH = "/devices/%s/methods/devicebound";
    private static final String MODULE_SENDER_LINK_ENDPOINT_PATH = "/devices/%s/modules/%s/methods/devicebound";
    private static final String SENDER_LINK_TAG_PREFIX = "sender_link_devicemethods-";
    private static final String LINK_TYPE = "methods";

    AmqpsMethodsSenderLinkHandler(Sender sender, AmqpsLinkStateCallback amqpsLinkStateCallback, DeviceClientConfig deviceClientConfig, String linkCorrelationId) {
        super(sender, amqpsLinkStateCallback, linkCorrelationId);
        this.senderLinkTag = AmqpsMethodsSenderLinkHandler.getTag(deviceClientConfig, linkCorrelationId);
        this.senderLinkAddress = AmqpsMethodsSenderLinkHandler.getAddress(deviceClientConfig);
        this.amqpProperties.put(Symbol.getSymbol((String)CORRELATION_ID_KEY), Symbol.getSymbol((String)(CORRELATION_ID_KEY_PREFIX + this.linkCorrelationId)));
        this.amqpProperties.put(Symbol.getSymbol((String)"com.microsoft:client-version"), deviceClientConfig.getProductInfo().getUserAgentString());
    }

    static String getTag(DeviceClientConfig deviceClientConfig, String linkCorrelationId) {
        String moduleId = deviceClientConfig.getModuleId();
        String deviceId = deviceClientConfig.getDeviceId();
        if (moduleId != null && !moduleId.isEmpty()) {
            return SENDER_LINK_TAG_PREFIX + deviceId + "/" + moduleId + "-" + linkCorrelationId;
        }
        return SENDER_LINK_TAG_PREFIX + deviceId + "-" + linkCorrelationId;
    }

    private static String getAddress(DeviceClientConfig deviceClientConfig) {
        String moduleId = deviceClientConfig.getModuleId();
        String deviceId = deviceClientConfig.getDeviceId();
        if (moduleId != null && !moduleId.isEmpty()) {
            return String.format(MODULE_SENDER_LINK_ENDPOINT_PATH, deviceId, moduleId);
        }
        return String.format(DEVICE_SENDER_LINK_ENDPOINT_PATH, deviceId);
    }

    @Override
    public String getLinkInstanceType() {
        return LINK_TYPE;
    }

    @Override
    protected MessageImpl iotHubMessageToProtonMessage(Message message) {
        if (message.getMessageType() == MessageType.DEVICE_METHODS) {
            MessageImpl protonMessage = super.iotHubMessageToProtonMessage(message);
            IotHubTransportMessage deviceMethodMessage = (IotHubTransportMessage)message;
            Properties properties = protonMessage.getProperties() != null ? protonMessage.getProperties() : new Properties();
            if (deviceMethodMessage.getRequestId() != null) {
                properties.setCorrelationId((Object)UUID.fromString(deviceMethodMessage.getRequestId()));
            }
            protonMessage.setProperties(properties);
            HashMap<String, Integer> userProperties = new HashMap<String, Integer>();
            if (deviceMethodMessage.getStatus() != null) {
                userProperties.put(APPLICATION_PROPERTY_KEY_IOTHUB_STATUS, Integer.parseInt(deviceMethodMessage.getStatus()));
            }
            if (protonMessage.getApplicationProperties() != null && protonMessage.getApplicationProperties().getValue() != null) {
                Map applicationPropertiesMap = protonMessage.getApplicationProperties().getValue();
                userProperties.putAll(applicationPropertiesMap);
            }
            ApplicationProperties applicationProperties = new ApplicationProperties(userProperties);
            protonMessage.setApplicationProperties(applicationProperties);
            return protonMessage;
        }
        return null;
    }
}

