/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsCbsSessionHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSessionHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AuthenticationMessageCallback;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.reactor.Reactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpsSasTokenRenewalHandler
extends BaseHandler
implements AuthenticationMessageCallback {
    private static final Logger log = LoggerFactory.getLogger(AmqpsSasTokenRenewalHandler.class);
    private static final int RETRY_INTERVAL_MILLISECONDS = 5000;
    AmqpsCbsSessionHandler amqpsCbsSessionHandler;
    AmqpsSessionHandler amqpsSessionHandler;

    public void onTimerTask(Event event) {
        log.trace("onTimerTask fired for sas token renewal handler for device {}", (Object)this.amqpsSessionHandler.getDeviceId());
        try {
            this.sendAuthenticationMessage(event.getReactor());
        }
        catch (TransportException e) {
            log.error("Failed to send the CBS authentication message to authenticate device {}, trying to send again in {} milliseconds", (Object)this.amqpsSessionHandler.getDeviceId(), (Object)5000);
            this.scheduleRenewalRetry(event.getReactor());
        }
    }

    public void sendAuthenticationMessage(Reactor reactor) throws TransportException {
        log.debug("Sending authentication message for device {}", (Object)this.amqpsSessionHandler.getDeviceId());
        this.amqpsCbsSessionHandler.sendAuthenticationMessage(this.amqpsSessionHandler.getDeviceClientConfig(), this);
        this.scheduleRenewal(reactor);
    }

    @Override
    public DeliveryState handleAuthenticationResponseMessage(int status, String description) {
        if (status == 200) {
            log.debug("CBS message authentication succeeded for device {}", (Object)this.amqpsSessionHandler.getDeviceId());
            this.amqpsSessionHandler.openLinks();
            return Accepted.getInstance();
        }
        this.amqpsCbsSessionHandler.onAuthenticationFailed(IotHubStatusCode.getConnectionStatusException(IotHubStatusCode.getIotHubStatusCode(status), description));
        return Accepted.getInstance();
    }

    private void scheduleRenewal(Reactor reactor) {
        int sasTokenRenewalPeriod = this.amqpsSessionHandler.getDeviceClientConfig().getSasTokenAuthentication().getMillisecondsBeforeProactiveRenewal();
        log.trace("Scheduling proactive sas token renewal for device {} in {} milliseconds", (Object)this.amqpsSessionHandler.getDeviceId(), (Object)sasTokenRenewalPeriod);
        reactor.schedule(sasTokenRenewalPeriod, (Handler)this);
    }

    private void scheduleRenewalRetry(Reactor reactor) {
        reactor.schedule(5000, (Handler)this);
    }

    public AmqpsSasTokenRenewalHandler(AmqpsCbsSessionHandler amqpsCbsSessionHandler, AmqpsSessionHandler amqpsSessionHandler) {
        this.amqpsCbsSessionHandler = amqpsCbsSessionHandler;
        this.amqpsSessionHandler = amqpsSessionHandler;
    }
}

