/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsLinkStateCallback;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMethodsReceiverLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMethodsSenderLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsReceiverLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSendResult;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSenderLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsSessionStateCallback;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsTelemetryReceiverLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsTelemetrySenderLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsTwinReceiverLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsTwinSenderLinkHandler;
import com.microsoft.azure.sdk.iot.device.transport.amqps.SubscriptionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpsSessionHandler
extends BaseHandler
implements AmqpsLinkStateCallback {
    private static final Logger log = LoggerFactory.getLogger(AmqpsSessionHandler.class);
    private final DeviceClientConfig deviceClientConfig;
    private final Map<Integer, SubscriptionType> implicitInProgressSubscriptionMessages = new ConcurrentHashMap<Integer, SubscriptionType>();
    private IotHubTransportMessage explicitInProgressTwinSubscriptionMessage;
    private IotHubTransportMessage explicitInProgressMethodsSubscriptionMessage;
    private boolean subscribeToMethodsOnReconnection = false;
    private boolean subscribeToTwinOnReconnection = false;
    private AmqpsSessionStateCallback amqpsSessionStateCallback;
    private List<AmqpsSenderLinkHandler> senderLinkHandlers = new ArrayList<AmqpsSenderLinkHandler>();
    private List<AmqpsReceiverLinkHandler> receiverLinkHandlers = new ArrayList<AmqpsReceiverLinkHandler>();
    private Session session;
    private boolean alreadyCreatedTelemetryLinks;
    private boolean alreadyCreatedTwinLinks;
    private boolean alreadyCreatedMethodLinks;
    private boolean twinSenderLinkOpened;
    private boolean twinReceiverLinkOpened;
    private boolean methodsSenderLinkOpened;
    private boolean methodsReceiverLinkOpened;

    AmqpsSessionHandler(DeviceClientConfig deviceClientConfig, AmqpsSessionStateCallback amqpsSessionStateCallback) {
        this.deviceClientConfig = deviceClientConfig;
        this.amqpsSessionStateCallback = amqpsSessionStateCallback;
    }

    public void setSession(Session session) {
        this.session = session;
        BaseHandler.setHandler((Extendable)this.session, (Handler)this);
        this.session.open();
        this.alreadyCreatedTelemetryLinks = false;
        this.alreadyCreatedTwinLinks = false;
        this.alreadyCreatedMethodLinks = false;
        this.senderLinkHandlers.clear();
        this.receiverLinkHandlers.clear();
        this.explicitInProgressTwinSubscriptionMessage = null;
        this.explicitInProgressMethodsSubscriptionMessage = null;
        this.implicitInProgressSubscriptionMessages.clear();
        this.twinSenderLinkOpened = false;
        this.twinReceiverLinkOpened = false;
        this.methodsSenderLinkOpened = false;
        this.methodsReceiverLinkOpened = false;
    }

    public void closeSession() {
        this.session.close();
    }

    public String getDeviceId() {
        return this.deviceClientConfig.getDeviceId();
    }

    public void onSessionRemoteOpen(Event e) {
        log.trace("Device session opened remotely for device {}", (Object)this.getDeviceId());
        if (this.deviceClientConfig.getAuthenticationType() == DeviceClientConfig.AuthType.X509_CERTIFICATE) {
            this.openLinks();
        } else {
            log.trace("Device session for device {} opened locally", (Object)this.getDeviceId());
        }
    }

    public void onSessionLocalOpen(Event e) {
        log.trace("Device session opened locally for device {}", (Object)this.getDeviceId());
    }

    public void onSessionRemoteClose(Event e) {
        Session session = e.getSession();
        if (session.getLocalState() == EndpointState.ACTIVE) {
            log.debug("Amqp device session closed remotely unexpectedly for device {}", (Object)this.getDeviceId());
            this.amqpsSessionStateCallback.onSessionClosedUnexpectedly(session.getRemoteCondition());
            this.session.close();
        } else {
            log.trace("Amqp device session closed remotely as expected for device {}", (Object)this.getDeviceId());
        }
    }

    public void onSessionLocalClose(Event e) {
        log.debug("Amqp session closed locally for device {}", (Object)this.getDeviceId());
        this.closeLinks();
        this.senderLinkHandlers.clear();
        this.receiverLinkHandlers.clear();
    }

    @Override
    public void onLinkOpened(BaseHandler linkHandler) {
        boolean allLinksOpen = true;
        for (AmqpsSenderLinkHandler senderLinkHandler : this.senderLinkHandlers) {
            allLinksOpen &= senderLinkHandler.senderLink != null && senderLinkHandler.senderLink.getRemoteState() == EndpointState.ACTIVE;
        }
        for (AmqpsReceiverLinkHandler receiverLinkHandler : this.receiverLinkHandlers) {
            allLinksOpen &= receiverLinkHandler.receiverLink != null && receiverLinkHandler.receiverLink.getRemoteState() == EndpointState.ACTIVE;
        }
        if (allLinksOpen) {
            this.amqpsSessionStateCallback.onDeviceSessionOpened(this.getDeviceId());
        }
        if (linkHandler instanceof AmqpsTwinSenderLinkHandler) {
            int deliveryTag = ((AmqpsTwinSenderLinkHandler)linkHandler).sendDesiredPropertiesSubscriptionMessage();
            if (deliveryTag == -1) {
                log.warn("Failed to send desired properties subscription message");
            } else {
                this.implicitInProgressSubscriptionMessages.put(deliveryTag, SubscriptionType.DESIRED_PROPERTIES_SUBSCRIPTION);
            }
        }
        this.acknowledgeExplicitSubscriptionMessages(linkHandler);
    }

    private void acknowledgeExplicitSubscriptionMessages(BaseHandler linkHandler) {
        if (linkHandler instanceof AmqpsTwinSenderLinkHandler) {
            this.twinSenderLinkOpened = true;
            if (this.twinReceiverLinkOpened && this.explicitInProgressTwinSubscriptionMessage != null) {
                this.amqpsSessionStateCallback.onMessageAcknowledged(this.explicitInProgressTwinSubscriptionMessage);
                this.explicitInProgressTwinSubscriptionMessage = null;
            }
        } else if (linkHandler instanceof AmqpsTwinReceiverLinkHandler) {
            this.twinReceiverLinkOpened = true;
            if (this.twinSenderLinkOpened && this.explicitInProgressTwinSubscriptionMessage != null) {
                this.amqpsSessionStateCallback.onMessageAcknowledged(this.explicitInProgressTwinSubscriptionMessage);
                this.explicitInProgressTwinSubscriptionMessage = null;
            }
        } else if (linkHandler instanceof AmqpsMethodsSenderLinkHandler) {
            this.methodsSenderLinkOpened = true;
            if (this.methodsReceiverLinkOpened && this.explicitInProgressMethodsSubscriptionMessage != null) {
                this.amqpsSessionStateCallback.onMessageAcknowledged(this.explicitInProgressMethodsSubscriptionMessage);
                this.explicitInProgressMethodsSubscriptionMessage = null;
            }
        } else if (linkHandler instanceof AmqpsMethodsReceiverLinkHandler) {
            this.methodsReceiverLinkOpened = true;
            if (this.methodsSenderLinkOpened && this.explicitInProgressMethodsSubscriptionMessage != null) {
                this.amqpsSessionStateCallback.onMessageAcknowledged(this.explicitInProgressMethodsSubscriptionMessage);
                this.explicitInProgressMethodsSubscriptionMessage = null;
            }
        }
    }

    @Override
    public void onMessageAcknowledged(Message message, int deliveryTag) {
        if (this.implicitInProgressSubscriptionMessages.containsKey(deliveryTag)) {
            this.implicitInProgressSubscriptionMessages.remove(deliveryTag);
            log.trace("The acknowledged message was the desired properties subscription message");
        } else {
            this.amqpsSessionStateCallback.onMessageAcknowledged(message);
        }
    }

    @Override
    public void onMessageReceived(IotHubTransportMessage message) {
        this.amqpsSessionStateCallback.onMessageReceived(message);
    }

    @Override
    public void onLinkClosedUnexpectedly(ErrorCondition errorCondition) {
        log.trace("Link closed unexpectedly for the amqp session of device {}", (Object)this.getDeviceId());
        this.session.close();
        this.amqpsSessionStateCallback.onSessionClosedUnexpectedly(errorCondition);
    }

    public boolean acknowledgeReceivedMessage(IotHubTransportMessage message, DeliveryState ackType) {
        for (AmqpsReceiverLinkHandler linksHandler : this.receiverLinkHandlers) {
            if (!linksHandler.acknowledgeReceivedMessage(message, ackType)) continue;
            return true;
        }
        return false;
    }

    void openLinks() {
        if (!this.alreadyCreatedTelemetryLinks) {
            this.createTelemetryLinks();
        }
        if (this.subscribeToTwinOnReconnection && !this.alreadyCreatedTwinLinks) {
            this.createTwinLinks();
        }
        if (this.subscribeToMethodsOnReconnection && !this.alreadyCreatedMethodLinks) {
            this.createMethodLinks();
        }
    }

    boolean sendMessage(Message message) {
        if (this.deviceClientConfig.getDeviceId().equals(message.getConnectionDeviceId())) {
            if (message.getMessageType() == null) {
                message.setMessageType(MessageType.DEVICE_TELEMETRY);
            }
            MessageType messageType = message.getMessageType();
            if (message instanceof IotHubTransportMessage) {
                IotHubTransportMessage transportMessage = (IotHubTransportMessage)message;
                DeviceOperations subscriptionType = ((IotHubTransportMessage)message).getDeviceOperationType();
                if (subscriptionType == DeviceOperations.DEVICE_OPERATION_METHOD_SUBSCRIBE_REQUEST) {
                    if (this.methodsSenderLinkOpened && this.methodsReceiverLinkOpened) {
                        this.amqpsSessionStateCallback.onMessageAcknowledged(message);
                        return true;
                    }
                    if (this.explicitInProgressMethodsSubscriptionMessage == null) {
                        this.createMethodLinks();
                        this.explicitInProgressMethodsSubscriptionMessage = transportMessage;
                        return true;
                    }
                    log.debug("Rejecting methods subscription message because that subscription is already in progress");
                    return false;
                }
                if (subscriptionType != DeviceOperations.DEVICE_OPERATION_TWIN_UNSUBSCRIBE_DESIRED_PROPERTIES_REQUEST && subscriptionType == DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST) {
                    if (this.twinSenderLinkOpened && this.twinReceiverLinkOpened) {
                        this.amqpsSessionStateCallback.onMessageAcknowledged(message);
                        return true;
                    }
                    if (this.explicitInProgressTwinSubscriptionMessage == null) {
                        this.createTwinLinks();
                        this.explicitInProgressTwinSubscriptionMessage = transportMessage;
                        return true;
                    }
                    log.debug("Rejecting twin subscription message because that subscription is already in progress");
                    return false;
                }
            }
            for (AmqpsSenderLinkHandler senderLinkHandler : this.senderLinkHandlers) {
                AmqpsSendResult amqpsSendResult;
                if (!(senderLinkHandler instanceof AmqpsTelemetrySenderLinkHandler && messageType == MessageType.DEVICE_TELEMETRY || senderLinkHandler instanceof AmqpsTwinSenderLinkHandler && messageType == MessageType.DEVICE_TWIN) && (!(senderLinkHandler instanceof AmqpsMethodsSenderLinkHandler) || messageType != MessageType.DEVICE_METHODS) || !(amqpsSendResult = senderLinkHandler.sendMessageAndGetDeliveryTag(message)).isDeliverySuccessful()) continue;
                return true;
            }
        }
        return false;
    }

    private void closeLinks() {
        for (AmqpsSenderLinkHandler senderLinkHandler : this.senderLinkHandlers) {
            senderLinkHandler.close();
        }
        for (AmqpsReceiverLinkHandler receiverLinkHandler : this.receiverLinkHandlers) {
            receiverLinkHandler.close();
        }
    }

    private void createTelemetryLinks() {
        String telemetryLinkCorrelationId = UUID.randomUUID().toString();
        Sender sender = this.session.sender(AmqpsTelemetrySenderLinkHandler.getTag(this.deviceClientConfig, telemetryLinkCorrelationId));
        this.senderLinkHandlers.add(new AmqpsTelemetrySenderLinkHandler(sender, this, this.deviceClientConfig, telemetryLinkCorrelationId));
        Receiver receiver = this.session.receiver(AmqpsTelemetryReceiverLinkHandler.getTag(this.deviceClientConfig, telemetryLinkCorrelationId));
        this.receiverLinkHandlers.add(new AmqpsTelemetryReceiverLinkHandler(receiver, this, this.deviceClientConfig, telemetryLinkCorrelationId));
        this.alreadyCreatedTelemetryLinks = true;
    }

    private void createMethodLinks() {
        String methodsLinkCorrelationId = UUID.randomUUID().toString();
        Sender sender = this.session.sender(AmqpsMethodsSenderLinkHandler.getTag(this.deviceClientConfig, methodsLinkCorrelationId));
        this.senderLinkHandlers.add(new AmqpsMethodsSenderLinkHandler(sender, this, this.deviceClientConfig, methodsLinkCorrelationId));
        Receiver receiver = this.session.receiver(AmqpsMethodsReceiverLinkHandler.getTag(this.deviceClientConfig, methodsLinkCorrelationId));
        this.receiverLinkHandlers.add(new AmqpsMethodsReceiverLinkHandler(receiver, this, this.deviceClientConfig, methodsLinkCorrelationId));
        this.subscribeToMethodsOnReconnection = true;
        this.alreadyCreatedMethodLinks = true;
    }

    private void createTwinLinks() {
        String twinLinkCorrelationId = UUID.randomUUID().toString();
        HashMap<String, DeviceOperations> twinOperationCorrelationMap = new HashMap<String, DeviceOperations>();
        Sender sender = this.session.sender(AmqpsTwinSenderLinkHandler.getTag(this.deviceClientConfig, twinLinkCorrelationId));
        this.senderLinkHandlers.add(new AmqpsTwinSenderLinkHandler(sender, this, this.deviceClientConfig, twinLinkCorrelationId, twinOperationCorrelationMap));
        Receiver receiver = this.session.receiver(AmqpsTwinReceiverLinkHandler.getTag(this.deviceClientConfig, twinLinkCorrelationId));
        this.receiverLinkHandlers.add(new AmqpsTwinReceiverLinkHandler(receiver, this, this.deviceClientConfig, twinLinkCorrelationId, twinOperationCorrelationMap));
        this.subscribeToTwinOnReconnection = true;
        this.alreadyCreatedTwinLinks = true;
    }

    public DeviceClientConfig getDeviceClientConfig() {
        return this.deviceClientConfig;
    }
}

