/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsLinkStateCallback;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsReceiverLinkHandler;
import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.engine.Receiver;

public final class AmqpsTelemetryReceiverLinkHandler
extends AmqpsReceiverLinkHandler {
    private static final String CORRELATION_ID_KEY = "com.microsoft:channel-correlation-id";
    private static final String DEVICE_RECEIVER_LINK_ENDPOINT_PATH = "/devices/%s/messages/devicebound";
    private static final String MODULE_RECEIVER_LINK_ENDPOINT_PATH_EDGEHUB = "/devices/%s/modules/%s/messages/events";
    private static final String MODULE_RECEIVER_LINK_ENDPOINT_PATH_IOTHUB = "/devices/%s/modules/%s/messages/devicebound";
    private static final String RECEIVER_LINK_TAG_PREFIX = "receiver_link_telemetry-";
    private static final String INPUT_NAME_PROPERTY_KEY = "x-opt-input-name";
    private static final String LINK_TYPE = "telemetry";
    private DeviceClientConfig deviceClientConfig;

    AmqpsTelemetryReceiverLinkHandler(Receiver receiver, AmqpsLinkStateCallback amqpsLinkStateCallback, DeviceClientConfig deviceClientConfig, String linkCorrelationId) {
        super(receiver, amqpsLinkStateCallback, linkCorrelationId);
        this.deviceClientConfig = deviceClientConfig;
        this.receiverLinkTag = AmqpsTelemetryReceiverLinkHandler.getTag(deviceClientConfig, linkCorrelationId);
        this.receiverLinkAddress = AmqpsTelemetryReceiverLinkHandler.getAddress(deviceClientConfig);
        this.amqpProperties.put(Symbol.getSymbol((String)"com.microsoft:client-version"), deviceClientConfig.getProductInfo().getUserAgentString());
        String moduleId = this.deviceClientConfig.getModuleId();
        if (moduleId != null) {
            this.amqpProperties.put(Symbol.getSymbol((String)CORRELATION_ID_KEY), Symbol.getSymbol((String)(this.deviceClientConfig.getDeviceId() + "/" + moduleId)));
        } else {
            this.amqpProperties.put(Symbol.getSymbol((String)CORRELATION_ID_KEY), Symbol.getSymbol((String)this.deviceClientConfig.getDeviceId()));
        }
    }

    static String getTag(DeviceClientConfig clientConfig, String linkCorrelationId) {
        String moduleId = clientConfig.getModuleId();
        String deviceId = clientConfig.getDeviceId();
        if (moduleId != null && !moduleId.isEmpty()) {
            return RECEIVER_LINK_TAG_PREFIX + deviceId + "/" + moduleId + "-" + linkCorrelationId;
        }
        return RECEIVER_LINK_TAG_PREFIX + deviceId + "-" + linkCorrelationId;
    }

    private static String getAddress(DeviceClientConfig deviceClientConfig) {
        String moduleId = deviceClientConfig.getModuleId();
        String deviceId = deviceClientConfig.getDeviceId();
        if (moduleId != null && !moduleId.isEmpty()) {
            if (deviceClientConfig.getGatewayHostname() != null) {
                return String.format(MODULE_RECEIVER_LINK_ENDPOINT_PATH_EDGEHUB, deviceId, moduleId);
            }
            return String.format(MODULE_RECEIVER_LINK_ENDPOINT_PATH_IOTHUB, deviceId, moduleId);
        }
        return String.format(DEVICE_RECEIVER_LINK_ENDPOINT_PATH, deviceId);
    }

    @Override
    public String getLinkInstanceType() {
        return LINK_TYPE;
    }

    @Override
    protected IotHubTransportMessage protonMessageToIoTHubMessage(AmqpsMessage protonMsg) {
        IotHubTransportMessage iotHubTransportMessage = super.protonMessageToIoTHubMessage(protonMsg);
        iotHubTransportMessage.setMessageType(MessageType.DEVICE_TELEMETRY);
        iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
        if (protonMsg.getMessageAnnotations() != null && protonMsg.getMessageAnnotations().getValue() != null) {
            Map applicationProperties = protonMsg.getMessageAnnotations().getValue();
            for (Map.Entry entry : applicationProperties.entrySet()) {
                String propertyKey = ((Symbol)entry.getKey()).toString();
                if (!propertyKey.equals(INPUT_NAME_PROPERTY_KEY)) continue;
                iotHubTransportMessage.setInputName(entry.getValue().toString());
            }
        }
        String inputName = iotHubTransportMessage.getInputName();
        MessageCallback messageCallback = this.deviceClientConfig.getDeviceTelemetryMessageCallback(inputName);
        Object messageContext = this.deviceClientConfig.getDeviceTelemetryMessageContext(inputName);
        iotHubTransportMessage.setMessageCallback(messageCallback);
        iotHubTransportMessage.setMessageCallbackContext(messageContext);
        return iotHubTransportMessage;
    }
}

