/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.amqps;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsLinkStateCallback;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.amqps.AmqpsReceiverLinkHandler;
import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AmqpsTwinReceiverLinkHandler
extends AmqpsReceiverLinkHandler {
    private static final Logger log = LoggerFactory.getLogger(AmqpsTwinReceiverLinkHandler.class);
    private static final String CORRELATION_ID_KEY = "com.microsoft:channel-correlation-id";
    private static final String CORRELATION_ID_KEY_PREFIX = "twin:";
    private static final String DEVICE_RECEIVER_LINK_ENDPOINT_PATH = "/devices/%s/twin";
    private static final String MODULE_RECEIVER_LINK_ENDPOINT_PATH = "/devices/%s/modules/%s/twin";
    private static final String RECEIVER_LINK_TAG_PREFIX = "receiver_link_devicetwin-";
    private static final String MESSAGE_ANNOTATION_FIELD_KEY_RESOURCE = "resource";
    private static final String MESSAGE_ANNOTATION_FIELD_KEY_STATUS = "status";
    private static final String MESSAGE_ANNOTATION_FIELD_KEY_VERSION = "version";
    private static final String DEFAULT_STATUS_CODE = "200";
    private static final String MESSAGE_ANNOTATION_FIELD_VALUE_PROPERTIES_DESIRED = "/properties/desired";
    private Map<String, DeviceOperations> twinOperationCorrelationMap;
    private static final String LINK_TYPE = "twin";
    private DeviceClientConfig deviceClientConfig;

    AmqpsTwinReceiverLinkHandler(Receiver receiver, AmqpsLinkStateCallback amqpsLinkStateCallback, DeviceClientConfig deviceClientConfig, String linkCorrelationId, Map<String, DeviceOperations> twinOperationCorrelationMap) {
        super(receiver, amqpsLinkStateCallback, linkCorrelationId);
        this.deviceClientConfig = deviceClientConfig;
        this.receiverLinkTag = AmqpsTwinReceiverLinkHandler.getTag(deviceClientConfig, linkCorrelationId);
        this.receiverLinkAddress = AmqpsTwinReceiverLinkHandler.getAddress(deviceClientConfig);
        this.amqpProperties.put(Symbol.getSymbol((String)CORRELATION_ID_KEY), Symbol.getSymbol((String)(CORRELATION_ID_KEY_PREFIX + this.linkCorrelationId)));
        this.amqpProperties.put(Symbol.getSymbol((String)"com.microsoft:client-version"), deviceClientConfig.getProductInfo().getUserAgentString());
        this.twinOperationCorrelationMap = twinOperationCorrelationMap;
    }

    static String getTag(DeviceClientConfig deviceClientConfig, String linkCorrelationId) {
        String moduleId = deviceClientConfig.getModuleId();
        String deviceId = deviceClientConfig.getDeviceId();
        if (moduleId != null && !moduleId.isEmpty()) {
            return RECEIVER_LINK_TAG_PREFIX + deviceId + "/" + moduleId + "-" + linkCorrelationId;
        }
        return RECEIVER_LINK_TAG_PREFIX + deviceId + "-" + linkCorrelationId;
    }

    private static String getAddress(DeviceClientConfig deviceClientConfig) {
        String moduleId = deviceClientConfig.getModuleId();
        String deviceId = deviceClientConfig.getDeviceId();
        if (moduleId != null && !moduleId.isEmpty()) {
            return String.format(MODULE_RECEIVER_LINK_ENDPOINT_PATH, deviceId, moduleId);
        }
        return String.format(DEVICE_RECEIVER_LINK_ENDPOINT_PATH, deviceId);
    }

    @Override
    public String getLinkInstanceType() {
        return LINK_TYPE;
    }

    @Override
    protected IotHubTransportMessage protonMessageToIoTHubMessage(AmqpsMessage protonMsg) {
        Properties properties;
        IotHubTransportMessage iotHubTransportMessage = super.protonMessageToIoTHubMessage(protonMsg);
        MessageCallback messageCallback = this.deviceClientConfig.getDeviceTwinMessageCallback();
        Object messageContext = this.deviceClientConfig.getDeviceTwinMessageContext();
        iotHubTransportMessage.setMessageCallback(messageCallback);
        iotHubTransportMessage.setMessageCallbackContext(messageContext);
        iotHubTransportMessage.setMessageType(MessageType.DEVICE_TWIN);
        iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_UNKNOWN);
        MessageAnnotations messageAnnotations = protonMsg.getMessageAnnotations();
        if (messageAnnotations != null) {
            for (Map.Entry entry : messageAnnotations.getValue().entrySet()) {
                Symbol key = (Symbol)entry.getKey();
                Object value = entry.getValue();
                if (key.toString().equals(MESSAGE_ANNOTATION_FIELD_KEY_STATUS)) {
                    iotHubTransportMessage.setStatus(value.toString());
                    continue;
                }
                if (key.toString().equals(MESSAGE_ANNOTATION_FIELD_KEY_VERSION)) {
                    iotHubTransportMessage.setVersion(value.toString());
                    continue;
                }
                if (!key.toString().equals(MESSAGE_ANNOTATION_FIELD_KEY_RESOURCE) || !value.toString().equals(MESSAGE_ANNOTATION_FIELD_VALUE_PROPERTIES_DESIRED)) continue;
                iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
            }
        }
        if ((properties = protonMsg.getProperties()) != null && properties.getCorrelationId() != null) {
            iotHubTransportMessage.setCorrelationId(properties.getCorrelationId().toString());
            if (this.twinOperationCorrelationMap.containsKey(properties.getCorrelationId().toString())) {
                DeviceOperations deviceOperations = this.twinOperationCorrelationMap.get(properties.getCorrelationId().toString());
                switch (deviceOperations) {
                    case DEVICE_OPERATION_TWIN_GET_REQUEST: {
                        iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_GET_RESPONSE);
                        break;
                    }
                    case DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_REQUEST: {
                        iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_RESPONSE);
                        break;
                    }
                    case DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST: {
                        iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
                        break;
                    }
                    case DEVICE_OPERATION_TWIN_UNSUBSCRIBE_DESIRED_PROPERTIES_REQUEST: {
                        iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_UNSUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
                        break;
                    }
                    default: {
                        log.error("Unrecognized device operation type during conversion of proton message into an iothub message");
                    }
                }
                this.twinOperationCorrelationMap.remove(properties.getCorrelationId().toString());
            }
        } else if (iotHubTransportMessage.getDeviceOperationType() == DeviceOperations.DEVICE_OPERATION_UNKNOWN) {
            iotHubTransportMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE);
            if (iotHubTransportMessage.getStatus() == null || iotHubTransportMessage.getStatus().isEmpty()) {
                iotHubTransportMessage.setStatus(DEFAULT_STATUS_CODE);
            }
        }
        return iotHubTransportMessage;
    }
}

