/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.https;

import com.microsoft.azure.sdk.iot.deps.util.Base64;
import com.microsoft.azure.sdk.iot.device.MessageProperty;
import com.microsoft.azure.sdk.iot.device.exceptions.IotHubSizeExceededException;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsSingleMessage;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class HttpsBatchMessage
implements HttpsMessage {
    private static final int SERVICEBOUND_MESSAGE_MAX_SIZE_BYTES = 261119;
    private static final String HTTPS_BATCH_CONTENT_TYPE = "application/vnd.microsoft.iothub.json";
    private static final Charset BATCH_CHARSET = StandardCharsets.UTF_8;
    private String batchBody = "[]";
    private int numMsgs = 0;

    public void addMessage(HttpsSingleMessage msg) throws IotHubSizeExceededException {
        String jsonMsg = HttpsBatchMessage.msgToJson(msg);
        String newBatchBody = HttpsBatchMessage.addJsonObjToArray(jsonMsg, this.batchBody);
        byte[] newBatchBodyBytes = newBatchBody.getBytes(BATCH_CHARSET);
        if (newBatchBodyBytes.length > 261119) {
            String errMsg = String.format("Service-bound message size (%d bytes) cannot exceed %d bytes.", newBatchBodyBytes.length, 261119);
            throw new IotHubSizeExceededException(errMsg);
        }
        this.batchBody = newBatchBody;
        ++this.numMsgs;
    }

    @Override
    public byte[] getBody() {
        return this.batchBody.getBytes(BATCH_CHARSET);
    }

    @Override
    public String getContentType() {
        return HTTPS_BATCH_CONTENT_TYPE;
    }

    @Override
    public MessageProperty[] getProperties() {
        return new MessageProperty[0];
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return new HashMap<String, String>();
    }

    public int numMessages() {
        return this.numMsgs;
    }

    private static String msgToJson(HttpsSingleMessage msg) {
        StringBuilder jsonMsg = new StringBuilder("{");
        jsonMsg.append("\"body\":");
        jsonMsg.append("\"").append(Base64.encodeBase64StringLocal((byte[])msg.getBody())).append("\",");
        jsonMsg.append("\"base64Encoded\":");
        jsonMsg.append(true);
        MessageProperty[] properties = msg.getProperties();
        HashMap<String, String> allProperties = new HashMap<String, String>(msg.getSystemProperties());
        for (MessageProperty p : properties) {
            allProperties.put(p.getName(), p.getValue());
        }
        int numProperties = allProperties.size();
        if (numProperties > 0) {
            jsonMsg.append(",");
            jsonMsg.append("\"properties\":");
            jsonMsg.append("{");
            for (String key : allProperties.keySet()) {
                jsonMsg.append("\"").append(key).append("\":");
                jsonMsg.append("\"").append((String)allProperties.get(key)).append("\",");
            }
            jsonMsg.deleteCharAt(jsonMsg.length() - 1);
            jsonMsg.append("}");
        }
        jsonMsg.append("}");
        return jsonMsg.toString();
    }

    private static String addJsonObjToArray(String jsonObj, String jsonArray) {
        if (jsonArray.equals("[]")) {
            return "[" + jsonObj + "]";
        }
        String openJsonArray = jsonArray.substring(0, jsonArray.length() - 1);
        return openJsonArray + "," + jsonObj + "]";
    }
}

