/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.https;

import com.microsoft.azure.sdk.iot.device.ProxySettings;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.HttpProxySocketFactory;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMethod;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class HttpsConnection {
    private final HttpURLConnection connection;
    private ProxySettings proxySettings;
    private byte[] body;

    public HttpsConnection(URL url, HttpsMethod method) throws TransportException {
        this(url, method, null);
    }

    public HttpsConnection(URL url, HttpsMethod method, ProxySettings proxySettings) throws TransportException {
        String protocol = url.getProtocol();
        if (!protocol.equalsIgnoreCase("HTTPS")) {
            String errMsg = String.format("Expected URL that uses protocol HTTPS but received one that uses protocol '%s'.%n", protocol);
            throw new IllegalArgumentException(errMsg);
        }
        this.body = new byte[0];
        try {
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setRequestMethod(method.name());
        }
        catch (IOException e) {
            throw HttpsConnection.buildTransportException(e);
        }
        this.proxySettings = proxySettings;
    }

    public void connect() throws TransportException {
        try {
            if (this.body.length > 0) {
                this.connection.setDoOutput(true);
                this.connection.getOutputStream().write(this.body);
            }
            this.connection.connect();
        }
        catch (IOException e) {
            throw HttpsConnection.buildTransportException(e);
        }
    }

    public void setRequestMethod(HttpsMethod method) throws TransportException {
        if (method != HttpsMethod.POST && method != HttpsMethod.PUT && this.body.length > 0) {
            throw new IllegalArgumentException("Cannot change the request method from POST or PUT when the request body is non-empty.");
        }
        try {
            this.connection.setRequestMethod(method.name());
        }
        catch (ProtocolException e) {
            throw new TransportException(e);
        }
        catch (SecurityException e) {
            throw new TransportException(e);
        }
    }

    public void setRequestHeader(String field, String value) {
        this.connection.setRequestProperty(field, value);
    }

    public void setReadTimeout(int timeout) {
        this.connection.setReadTimeout(timeout);
    }

    public void setConnectTimeout(int timeout) {
        this.connection.setConnectTimeout(timeout);
    }

    public void writeOutput(byte[] body) throws TransportException {
        HttpsMethod method = HttpsMethod.valueOf(this.connection.getRequestMethod());
        if (method != HttpsMethod.POST && method != HttpsMethod.PUT) {
            if (body.length > 0) {
                throw new IllegalArgumentException("Cannot write a body to a request that is not a POST or a PUT request.");
            }
        } else {
            this.body = Arrays.copyOf(body, body.length);
        }
    }

    public byte[] readInput() throws TransportException {
        try {
            byte[] input;
            try (InputStream inputStream = this.connection.getInputStream();){
                input = HttpsConnection.readInputStream(inputStream);
            }
            return input;
        }
        catch (IOException e) {
            throw HttpsConnection.buildTransportException(e);
        }
    }

    public byte[] readError() throws TransportException {
        try {
            byte[] error;
            try (InputStream errorStream = this.connection.getErrorStream();){
                error = new byte[]{};
                if (errorStream != null) {
                    error = HttpsConnection.readInputStream(errorStream);
                }
            }
            return error;
        }
        catch (IOException e) {
            throw HttpsConnection.buildTransportException(e);
        }
    }

    public int getResponseStatus() throws TransportException {
        try {
            return this.connection.getResponseCode();
        }
        catch (IOException e) {
            throw HttpsConnection.buildTransportException(e);
        }
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.connection.getHeaderFields();
    }

    private static byte[] readInputStream(InputStream stream) throws TransportException {
        try {
            ArrayList<Byte> byteBuffer = new ArrayList<Byte>();
            int nextByte = -1;
            while ((nextByte = stream.read()) > -1) {
                byteBuffer.add((byte)nextByte);
            }
            int bufferSize = byteBuffer.size();
            byte[] byteArray = new byte[bufferSize];
            for (int i = 0; i < bufferSize; ++i) {
                byteArray[i] = (Byte)byteBuffer.get(i);
            }
            return byteArray;
        }
        catch (IOException e) {
            throw HttpsConnection.buildTransportException(e);
        }
    }

    void setSSLContext(SSLContext sslContext) throws IllegalArgumentException {
        if (sslContext == null) {
            throw new IllegalArgumentException("SSL context cannot be null");
        }
        if (this.connection instanceof HttpsURLConnection) {
            if (this.proxySettings != null) {
                ((HttpsURLConnection)this.connection).setSSLSocketFactory(new HttpProxySocketFactory(sslContext.getSocketFactory(), this.proxySettings));
            } else {
                ((HttpsURLConnection)this.connection).setSSLSocketFactory(sslContext.getSocketFactory());
            }
        } else {
            throw new UnsupportedOperationException("HTTP connections do not support using ssl socket factory");
        }
    }

    protected HttpsConnection() {
        this.connection = null;
    }

    private static TransportException buildTransportException(IOException e) {
        TransportException transportException = new TransportException(e);
        if (e instanceof NoRouteToHostException || e instanceof UnknownHostException) {
            transportException.setRetryable(true);
        }
        return transportException;
    }

    byte[] getBody() {
        return this.body;
    }
}

