/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.ProxySettings;
import com.microsoft.azure.sdk.iot.device.exceptions.ProtocolException;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.HttpProxySocketFactory;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.Socks5SocketFactory;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.exceptions.PahoExceptionTranslator;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MqttConnection {
    private MqttAsyncClient mqttAsyncClient = null;
    private MqttConnectOptions connectionOptions = null;
    private ConcurrentLinkedQueue<Pair<String, byte[]>> allReceivedMessages;
    private Object mqttLock;
    private static final int KEEP_ALIVE_INTERVAL = 230;
    private static final int MQTT_VERSION = 4;
    private static final boolean SET_CLEAN_SESSION = false;
    static final int QOS = 1;
    static final int MAX_SUBSCRIBE_ACK_WAIT_TIME = 15000;
    static final int MAX_IN_FLIGHT_COUNT = 10;

    MqttConnection(String serverURI, String clientId, String userName, String password, SSLContext sslContext, ProxySettings proxySettings) throws TransportException, IllegalArgumentException, UnknownHostException {
        if (serverURI == null || clientId == null || userName == null || sslContext == null) {
            throw new IllegalArgumentException("ServerURI, clientId, and userName may not be null or empty");
        }
        if (serverURI.isEmpty() || clientId.isEmpty() || userName.isEmpty()) {
            throw new IllegalArgumentException("ServerURI, clientId, and userName may not be null or empty");
        }
        try {
            this.mqttAsyncClient = new MqttAsyncClient(serverURI, clientId, (MqttClientPersistence)new MemoryPersistence());
            this.mqttAsyncClient.setManualAcks(true);
            this.connectionOptions = new MqttConnectOptions();
            this.updateConnectionOptions(userName, password, sslContext, proxySettings);
        }
        catch (MqttException e) {
            this.mqttAsyncClient = null;
            this.connectionOptions = null;
            ProtocolException transportException = PahoExceptionTranslator.convertToMqttException(e, "Unable to create mqttAsyncClient");
            throw transportException;
        }
        this.allReceivedMessages = new ConcurrentLinkedQueue();
        this.mqttLock = new Object();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateConnectionOptions(String userName, String userPassword, SSLContext iotHubSSLContext, ProxySettings proxySettings) throws UnknownHostException {
        this.connectionOptions.setKeepAliveInterval(230);
        this.connectionOptions.setCleanSession(false);
        this.connectionOptions.setMqttVersion(4);
        this.connectionOptions.setUserName(userName);
        if (proxySettings != null) {
            if (proxySettings.getProxy().type() == Proxy.Type.SOCKS) {
                this.connectionOptions.setSocketFactory((SocketFactory)new Socks5SocketFactory(proxySettings.getHostname(), proxySettings.getPort()));
            } else {
                if (proxySettings.getProxy().type() != Proxy.Type.HTTP) throw new IllegalArgumentException("Proxy settings must be configured to use either SOCKS or HTTP");
                this.connectionOptions.setSocketFactory((SocketFactory)new HttpProxySocketFactory(iotHubSSLContext.getSocketFactory(), proxySettings));
            }
        } else {
            this.connectionOptions.setSocketFactory((SocketFactory)iotHubSSLContext.getSocketFactory());
        }
        if (userPassword == null || userPassword.isEmpty()) return;
        this.connectionOptions.setPassword(userPassword.toCharArray());
    }

    void setMqttCallback(MqttCallback mqttCallback) throws IllegalArgumentException {
        if (mqttCallback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        this.getMqttAsyncClient().setCallback(mqttCallback);
    }

    MqttAsyncClient getMqttAsyncClient() {
        return this.mqttAsyncClient;
    }

    boolean isConnected() {
        if (this.mqttAsyncClient != null) {
            return this.mqttAsyncClient.isConnected();
        }
        return false;
    }

    IMqttToken disconnect() throws MqttException {
        if (this.mqttAsyncClient != null) {
            return this.mqttAsyncClient.disconnect();
        }
        return null;
    }

    void close() throws MqttException {
        if (this.mqttAsyncClient != null) {
            this.mqttAsyncClient.close();
        }
    }

    ConcurrentLinkedQueue<Pair<String, byte[]>> getAllReceivedMessages() {
        return this.allReceivedMessages;
    }

    Object getMqttLock() {
        return this.mqttLock;
    }

    MqttConnectOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    void setMqttAsyncClient(MqttAsyncClient mqttAsyncClient) {
        this.mqttAsyncClient = mqttAsyncClient;
    }

    boolean sendMessageAcknowledgement(int messageId) throws TransportException {
        try {
            this.mqttAsyncClient.messageArrivedComplete(messageId, 1);
            return true;
        }
        catch (MqttException e) {
            throw PahoExceptionTranslator.convertToMqttException(e, "Error sending message ack");
        }
    }
}

