/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class Socks5SocketFactory
extends SocketFactory {
    private final InetAddress mProxyHost;
    private final int mProxyPort;

    public Socks5SocketFactory(String host, int port) throws UnknownHostException {
        this.mProxyHost = InetAddress.getByName(host);
        this.mProxyPort = port;
    }

    @Override
    public Socket createSocket() {
        return new Socks5Socket();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(host.getHostName(), port, null, 0);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.createSocket(host.getHostName(), port, localHost, localPort);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.createSocket(host, port, null, 0);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket s = this.createSocket();
        if (localHost != null) {
            s.bind(new InetSocketAddress(localHost, localPort));
        }
        s.connect(new InetSocketAddress(host, port));
        return s;
    }

    private class Socks5Socket
    extends Socket {
        static final int CMD_CONNECT = 1;
        static final int ATYP_IPV4 = 1;
        static final int ATYP_DOMAINNAME = 3;
        static final int ATYP_IPV6 = 4;
        String mLocalHost;
        InetAddress mLocalIP;
        Proxied mProxied;
        InetSocketAddress mTarget;

        private Socks5Socket() {
        }

        byte[] getConnectCmd() {
            byte[] host = this.mTarget.getHostName().getBytes();
            byte[] data = new byte[7 + host.length];
            data[0] = 5;
            data[1] = 1;
            data[2] = 0;
            data[3] = 3;
            data[4] = (byte)host.length;
            System.arraycopy(host, 0, data, 5, host.length);
            data[data.length - 2] = (byte)(this.mTarget.getPort() >> 8);
            data[data.length - 1] = (byte)this.mTarget.getPort();
            return data;
        }

        void sendConnectCommand() throws IOException {
            InputStream in = this.getInputStream();
            OutputStream out = this.getOutputStream();
            try {
                out.write(new byte[]{5, 1, 0});
                out.flush();
                int version = in.read();
                int method = in.read();
                if (version < 0 || method != 0) {
                    this.close();
                    throw new IOException();
                }
            }
            catch (SocketException | UnknownHostException uh_ex) {
                this.close();
                throw new IOException(uh_ex);
            }
            out.write(this.getConnectCmd());
        }

        @Override
        public void connect(SocketAddress sa, int a) throws IOException {
            this.mTarget = (InetSocketAddress)sa;
            if (this.isLocal()) {
                super.connect(new InetSocketAddress(this.getDirectInetAddress(), this.mTarget.getPort()), 1000);
            } else {
                this.connectViaProxy(a);
            }
        }

        void connectViaProxy(int a) throws IOException {
            super.connect(new InetSocketAddress(Socks5SocketFactory.this.mProxyHost, Socks5SocketFactory.this.mProxyPort), a);
            this.sendConnectCommand();
            this.mProxied = new Proxied(this.getInputStream());
            if (!this.mProxied.mHost.equals("0.0.0.0")) {
                this.mLocalHost = this.mProxied.mHost;
                this.mLocalIP = this.mProxied.mIp;
            } else {
                this.mLocalIP = Socks5SocketFactory.this.mProxyHost;
                this.mLocalHost = this.mLocalIP.getHostName();
            }
        }

        InetAddress getDirectInetAddress() throws IOException {
            String hn;
            if (this.mTarget != null && (hn = this.mTarget.getHostName()) != null) {
                return InetAddress.getByName(hn);
            }
            throw new IOException();
        }

        boolean isLocal() {
            try {
                InetAddress address = this.getDirectInetAddress();
                return address != null && address.isSiteLocalAddress();
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public int getLocalPort() {
            return this.isLocal() ? super.getLocalPort() : this.mProxied.mPort;
        }

        @Override
        public InetAddress getLocalAddress() {
            if (this.isLocal()) {
                return super.getLocalAddress();
            }
            if (this.mLocalIP == null) {
                try {
                    this.mLocalIP = InetAddress.getByName(this.mLocalHost);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            return this.mLocalIP;
        }

        class Proxied {
            InetAddress mIp;
            int mPort;
            String mHost;

            Proxied(InputStream in) throws IOException {
                DataInputStream di = new DataInputStream(in);
                di.readUnsignedByte();
                if (di.readUnsignedByte() != 0) {
                    throw new IOException();
                }
                di.readUnsignedByte();
                int type = di.readUnsignedByte();
                switch (type) {
                    case 1: {
                        byte[] h = new byte[4];
                        di.readFully(h);
                        this.mHost = String.format("%s.%s.%s.%s", h[0] & 0xFF, h[1] & 0xFF, h[2] & 0xFF, h[3] & 0xFF);
                        break;
                    }
                    case 4: {
                        throw new IOException();
                    }
                    case 3: {
                        byte[] h = new byte[di.readUnsignedByte()];
                        di.readFully(h);
                        this.mHost = new String(h);
                        break;
                    }
                    default: {
                        throw new IOException();
                    }
                }
                this.mPort = di.readUnsignedShort();
                if (type != 3) {
                    try {
                        this.mIp = InetAddress.getByName(this.mHost);
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

