/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.CancellationErrorCode;
import com.microsoft.cognitiveservices.speech.CancellationReason;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.RecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public class CancellationDetails {
    private CancellationReason reason;
    private String errorDetails;
    private CancellationErrorCode errorCode;

    public static CancellationDetails fromResult(RecognitionResult result) {
        return new CancellationDetails(result);
    }

    CancellationDetails(RecognitionResult result) {
        Contracts.throwIfNull(result, "result");
        Contracts.throwIfNull(result.getImpl(), "result.resultHandle");
        IntRef value = new IntRef(0L);
        Contracts.throwIfFail(this.getCanceledReason(result.getImpl(), value));
        this.reason = CancellationReason.values()[(int)value.getValue() - 1];
        Contracts.throwIfFail(this.getCanceledErrorCode(result.getImpl(), value));
        this.errorCode = CancellationErrorCode.values()[(int)value.getValue()];
        this.errorDetails = result.getProperties().getProperty(PropertyId.SpeechServiceResponse_JsonErrorDetails);
    }

    public void close() {
    }

    public CancellationReason getReason() {
        return this.reason;
    }

    public CancellationErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "CancellationReason:" + (Object)((Object)this.reason) + " ErrorCode: " + (Object)((Object)this.errorCode) + " ErrorDetails:" + this.errorDetails;
    }

    private final native long getCanceledReason(SafeHandle var1, IntRef var2);

    private final native long getCanceledErrorCode(SafeHandle var1, IntRef var2);
}

