/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.ConnectionEventArgs;
import com.microsoft.cognitiveservices.speech.ConnectionMessageEventArgs;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.SpeechSynthesizer;
import com.microsoft.cognitiveservices.speech.dialog.DialogServiceConnector;
import com.microsoft.cognitiveservices.speech.transcription.ConversationTranslator;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public final class Connection
implements AutoCloseable {
    private AtomicInteger eventCounter = new AtomicInteger(0);
    public final EventHandlerImpl<ConnectionEventArgs> connected = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConnectionEventArgs> disconnected = new EventHandlerImpl(this.eventCounter);
    public final EventHandlerImpl<ConnectionMessageEventArgs> messageReceived = new EventHandlerImpl(this.eventCounter);
    static Set<Connection> _connectionObjects = Collections.synchronizedSet(new HashSet());
    private SafeHandle connectionHandle;
    private boolean disposed = false;
    private final Object connectionLock = new Object();
    private int activeAsyncConnectionCounter = 0;

    public static Connection fromRecognizer(Recognizer recognizer) {
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(Connection.connectionFromRecognizer(recognizer.getImpl(), handle));
        return new Connection(handle);
    }

    public static Connection fromConversationTranslator(ConversationTranslator conversationTranslator) {
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(Connection.connectionFromConversationTranslator(conversationTranslator.getImpl(), handle));
        return new Connection(handle);
    }

    public static Connection fromDialogServiceConnector(DialogServiceConnector dialogServiceConnector) {
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(Connection.connectionFromDialogServiceConnector(dialogServiceConnector.getImpl(), handle));
        return new Connection(handle);
    }

    public static Connection fromSpeechSynthesizer(SpeechSynthesizer speechSynthesizer) {
        IntRef handle = new IntRef(0L);
        Contracts.throwIfFail(Connection.connectionFromSpeechSynthesizer(speechSynthesizer.getImpl(), handle));
        return new Connection(handle);
    }

    public void openConnection(boolean forContinuousRecognition) {
        Contracts.throwIfFail(this.openConnection(this.connectionHandle, forContinuousRecognition));
    }

    public void closeConnection() {
        Contracts.throwIfFail(this.closeConnection(this.connectionHandle));
    }

    public Future<Void> sendMessageAsync(String path, String payload) {
        final Connection thisConnection = this;
        final String finalPath = path;
        final String finalPayload = payload;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Connection.this.connectionSendMessage(Connection.this.connectionHandle, finalPath, finalPayload));
                    }
                };
                thisConnection.doAsyncConnectionAction(runnable);
                return null;
            }
        });
    }

    public void setMessageProperty(String path, String propertyName, String propertyValue) {
        Contracts.throwIfFail(this.connectionSetMessageProperty(this.connectionHandle, path, propertyName, propertyValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncConnectionAction(Runnable connectionImplAction) {
        Object object = this.connectionLock;
        synchronized (object) {
            ++this.activeAsyncConnectionCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            connectionImplAction.run();
        }
        finally {
            object = this.connectionLock;
            synchronized (object) {
                --this.activeAsyncConnectionCounter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.activeAsyncConnectionCounter != 0) {
                throw new IllegalStateException("Cannot dispose a connection while async method is running. Await async method to avoid unexpected disposals.");
            }
            this.dispose(true);
        }
    }

    private void dispose(boolean disposing) {
        if (this.disposed) {
            return;
        }
        if (disposing) {
            if (this.connectionHandle != null) {
                this.connectionHandle.close();
                this.connectionHandle = null;
            }
            _connectionObjects.remove(this);
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    private Connection(IntRef handle) {
        Contracts.throwIfNull(handle, "Connection");
        this.connectionHandle = new SafeHandle(handle.getValue(), SafeHandleType.Connection);
        this.initialize();
    }

    private void initialize() {
        final Connection _this = this;
        AsyncThreadService.initialize();
        this.connected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                _connectionObjects.add(_this);
                Connection.this.connectionConnectedSetCallback(Connection.this.connectionHandle.getValue());
            }
        });
        this.disconnected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                _connectionObjects.add(_this);
                Connection.this.connectionDisconnectedSetCallback(Connection.this.connectionHandle.getValue());
            }
        });
        this.messageReceived.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                _connectionObjects.add(_this);
                Connection.this.connectionMessageReceivedSetCallback(Connection.this.connectionHandle.getValue());
            }
        });
    }

    private void connectedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "connection");
            if (this.disposed) {
                return;
            }
            ConnectionEventArgs args = new ConnectionEventArgs(eventArgs, true);
            EventHandlerImpl<ConnectionEventArgs> handler = this.connected;
            if (handler != null) {
                handler.fireEvent(this, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disconnectedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "connection");
            if (this.disposed) {
                return;
            }
            ConnectionEventArgs args = new ConnectionEventArgs(eventArgs, true);
            EventHandlerImpl<ConnectionEventArgs> handler = this.disconnected;
            if (handler != null) {
                handler.fireEvent(this, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void messageReceivedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "connection");
            if (this.disposed) {
                return;
            }
            ConnectionMessageEventArgs args = new ConnectionMessageEventArgs(eventArgs);
            EventHandlerImpl<ConnectionMessageEventArgs> handler = this.messageReceived;
            if (handler != null) {
                handler.fireEvent(this, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final native long connectionFromRecognizer(SafeHandle var0, IntRef var1);

    private static final native long connectionFromConversationTranslator(SafeHandle var0, IntRef var1);

    private static final native long connectionFromDialogServiceConnector(SafeHandle var0, IntRef var1);

    private static final native long connectionFromSpeechSynthesizer(SafeHandle var0, IntRef var1);

    private final native long openConnection(SafeHandle var1, boolean var2);

    private final native long closeConnection(SafeHandle var1);

    private final native long connectionSendMessage(SafeHandle var1, String var2, String var3);

    private final native long connectionSetMessageProperty(SafeHandle var1, String var2, String var3, String var4);

    private final native long connectionConnectedSetCallback(long var1);

    private final native long connectionDisconnectedSetCallback(long var1);

    private final native long connectionMessageReceivedSetCallback(long var1);
}

