/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class KeywordRecognitionModel
implements AutoCloseable {
    private boolean disposed = false;
    private SafeHandle keywordModelHandle = null;

    public static KeywordRecognitionModel fromFile(String fileName) {
        Contracts.throwIfFileDoesNotExist(fileName, "fileName");
        try {
            File f = new File(fileName);
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(new File(fileName)));
            byte[] magic = new byte[2];
            ((InputStream)inputStream).mark(4);
            int len = ((InputStream)inputStream).read(magic);
            ((InputStream)inputStream).reset();
            boolean isZipped = len == 2 && magic[0] == 80 && magic[1] == 75;
            KeywordRecognitionModel ret = null;
            if (isZipped) {
                ret = KeywordRecognitionModel.fromStream(inputStream, f.getName(), isZipped);
                ((InputStream)inputStream).close();
            } else {
                ((InputStream)inputStream).close();
                IntRef keywordModelHandle = new IntRef(0L);
                Contracts.throwIfFail(KeywordRecognitionModel.createKeywordRecognitionModelFromFile(f.getCanonicalPath(), keywordModelHandle));
                ret = new KeywordRecognitionModel(keywordModelHandle);
            }
            return ret;
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException("fileName not found");
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("could not access file " + ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeywordRecognitionModel fromStream(InputStream inputStream, String name, boolean isZipped) throws IOException {
        File kwsTableFile;
        Contracts.throwIfNull(inputStream, "inputStream");
        Contracts.throwIfNullOrWhitespace(name, "name");
        if (name.contains(File.separator) || name.contains(".") || name.contains(":")) {
            throw new IOException("name must not contain separator, ., or :");
        }
        String tempFolderStr = System.getProperty("java.io.tmpdir");
        Contracts.throwIfNullOrWhitespace(tempFolderStr, "tempFolder");
        String tempFolder = new File(tempFolderStr).getCanonicalPath();
        Contracts.throwIfNullOrWhitespace(tempFolder, "canonicalTempFolder");
        File kwsRootDirectory = new File(tempFolder, "speech-sdk-keyword-" + name).getCanonicalFile();
        if (!kwsRootDirectory.getCanonicalPath().startsWith(tempFolder)) {
            throw new IOException("invalid kws temp directory " + kwsRootDirectory.getCanonicalPath());
        }
        if (!kwsRootDirectory.exists()) {
            int len;
            if (!kwsRootDirectory.mkdirs()) {
                throw new IllegalArgumentException("cannot create directory");
            }
            kwsRootDirectory.deleteOnExit();
            if (!kwsRootDirectory.isDirectory()) {
                throw new IllegalArgumentException("path is not a directory");
            }
            byte[] buffer = new byte[0x100000];
            if (isZipped) {
                ZipEntry zipEntry;
                ZipInputStream zip = new ZipInputStream(inputStream);
                while ((zipEntry = zip.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    String zipEntryName = "" + zipEntry.getName();
                    if (zipEntryName.length() > 128 || zipEntryName.contains("..")) {
                        zipEntryName = "";
                    }
                    Contracts.throwIfNullOrWhitespace(zipEntryName, "zipEntry.name");
                    File outputFile = new File(kwsRootDirectory, zipEntryName);
                    if (!outputFile.getCanonicalPath().startsWith(kwsRootDirectory.getCanonicalPath())) {
                        throw new IOException("invalid file " + outputFile.getCanonicalPath());
                    }
                    if (outputFile.exists() && !outputFile.delete()) {
                        throw new IllegalArgumentException("could not delete " + outputFile.getCanonicalPath());
                    }
                    outputFile.deleteOnExit();
                    FileOutputStream outputStream2 = null;
                    try {
                        outputStream2 = new FileOutputStream(outputFile);
                        while ((len = zip.read(buffer)) > 0) {
                            outputStream2.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable) {
                        KeywordRecognitionModel.safeClose(outputStream2);
                        throw throwable;
                    }
                    KeywordRecognitionModel.safeClose(outputStream2);
                }
                zip.close();
            } else {
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(new File(kwsRootDirectory, "kws.table"));
                    while ((len = inputStream.read(buffer)) > 0) {
                        outputStream.write(buffer, 0, len);
                    }
                }
                catch (Throwable throwable) {
                    KeywordRecognitionModel.safeClose(outputStream);
                    throw throwable;
                }
                KeywordRecognitionModel.safeClose(outputStream);
            }
        }
        if ((kwsTableFile = new File(kwsRootDirectory, "kws.table")).exists() && kwsTableFile.isFile()) {
            IntRef keywordModelHandle = new IntRef(0L);
            Contracts.throwIfFail(KeywordRecognitionModel.createKeywordRecognitionModelFromFile(kwsTableFile.getCanonicalPath(), keywordModelHandle));
            return new KeywordRecognitionModel(keywordModelHandle);
        }
        throw new IllegalArgumentException("zip did not contain kws.table");
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.keywordModelHandle != null) {
            this.keywordModelHandle.close();
            this.keywordModelHandle = null;
        }
        this.disposed = true;
    }

    KeywordRecognitionModel(IntRef modelHandle) {
        Contracts.throwIfNull(modelHandle, "modelHandle");
        this.keywordModelHandle = new SafeHandle(modelHandle.getValue(), SafeHandleType.KeywordModel);
    }

    public SafeHandle getImpl() {
        return this.keywordModelHandle;
    }

    private static void safeClose(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final native long createKeywordRecognitionModelFromFile(String var0, IntRef var1);

    static {
        Class<?> clazz = SpeechConfig.speechConfigClass;
    }
}

