/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

class NativeLibraryLoader {
    private static final String tempDirPrefix = "speech-sdk-native-";
    private static final String lockFileExtension = ".lock";
    private static NativeLibrary[] nativeList = new NativeLibrary[0];
    private static NativeLibrary[] externalNativeList = new NativeLibrary[0];
    private static String operatingSystem;
    private static Boolean windowsOperatingSystem;
    private static Boolean extractionDone;
    private static Boolean loadAll;
    private static File tempDir;

    NativeLibraryLoader() {
    }

    public static void loadNativeBinding() {
        try {
            NativeLibraryLoader.extractNativeLibraries();
            for (int i = 0; i < nativeList.length; ++i) {
                if (!loadAll.booleanValue() && i != nativeList.length - 1) continue;
                String libName = nativeList[i].getName();
                String fullPathName = new File(tempDir.getCanonicalPath(), libName).getCanonicalPath();
                if (!fullPathName.startsWith(tempDir.getCanonicalPath())) {
                    throw new SecurityException("illegal path");
                }
                try {
                    System.load(fullPathName);
                    continue;
                }
                catch (UnsatisfiedLinkError e) {
                    if (!nativeList[i].getRequired()) continue;
                    throw new UnsatisfiedLinkError(String.format("Could not load a required Speech SDK library because of the following error: %s", e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            throw new UnsatisfiedLinkError(String.format("Could not extract/load all Speech SDK libraries because we encountered the following error: %s", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractNativeLibraries() throws Exception {
        block11: {
            try {
                if (extractionDone.booleanValue()) break block11;
                for (NativeLibrary library : nativeList = NativeLibraryLoader.getResourceLines()) {
                    NativeLibraryLoader.extractResourceFromPath(library, NativeLibraryLoader.getResourcesPath());
                }
                externalNativeList = NativeLibraryLoader.getExternalResourceLines();
                if (!windowsOperatingSystem.booleanValue()) break block11;
                String path = null;
                try {
                    URL classResource = ClassLoader.getSystemClassLoader().getResource(".");
                    if (classResource != null) {
                        path = new File(classResource.getPath()).getAbsolutePath();
                    } else {
                        path = new File(NativeLibraryLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
                        if (path.endsWith("jar")) {
                            path = new File(path).getParent();
                        }
                    }
                    path = URLDecoder.decode(path, "UTF-8");
                    if (path != null) {
                        for (NativeLibrary library : externalNativeList) {
                            NativeLibraryLoader.copyLibraryFromPath(library, path);
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println(String.format("Could not copy external Speech SDK libraries because of the following error: %s", e.getMessage()));
                }
            }
            finally {
                extractionDone = true;
            }
        }
    }

    private static NativeLibrary[] getResourceLines() throws IOException {
        if (operatingSystem.contains("linux")) {
            return new NativeLibrary[]{new NativeLibrary("libMicrosoft.CognitiveServices.Speech.core.so", true), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.kws.ort.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.kws.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.codec.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.audio.sys.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.lu.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.onnxruntime.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.sr.runtime.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.sr.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.tts.runtime.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.tts.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.telemetry.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.mas.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.vad.so", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.java.bindings.so", true)};
        }
        if (windowsOperatingSystem.booleanValue()) {
            return new NativeLibrary[]{new NativeLibrary("Microsoft.CognitiveServices.Speech.core.dll", true), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.kws.ort.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.kws.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.codec.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.audio.sys.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.lu.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.silk_codec.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.onnxruntime.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.embedded.sr.runtime.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.embedded.sr.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.embedded.tts.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.telemetry.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.mas.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.extension.vad.dll", false), new NativeLibrary("Microsoft.CognitiveServices.Speech.java.bindings.dll", true)};
        }
        if (operatingSystem.contains("mac") || operatingSystem.contains("darwin")) {
            return new NativeLibrary[]{new NativeLibrary("libMicrosoft.CognitiveServices.Speech.core.dylib", true), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.audio.sys.dylib", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.onnxruntime.dylib", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.sr.runtime.dylib", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.sr.dylib", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.embedded.tts.dylib", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.extension.telemetry.dylib", false), new NativeLibrary("libMicrosoft.CognitiveServices.Speech.java.bindings.dylib", true)};
        }
        throw new UnsatisfiedLinkError(String.format("The Speech SDK doesn't currently have native support for operating system: %s", operatingSystem));
    }

    private static NativeLibrary[] getExternalResourceLines() {
        if (windowsOperatingSystem.booleanValue()) {
            return new NativeLibrary[]{new NativeLibrary("carbon-tts-mock.dll", false)};
        }
        if (operatingSystem.contains("linux")) {
            return new NativeLibrary[0];
        }
        if (operatingSystem.contains("mac") || operatingSystem.contains("darwin")) {
            return new NativeLibrary[0];
        }
        return new NativeLibrary[0];
    }

    private static boolean useCentos7Binaries() {
        try {
            String overrideEOLSystem = System.getenv("SpeechSDK_UseCentos7Binaries");
            if (overrideEOLSystem != null) {
                return overrideEOLSystem.equalsIgnoreCase("true");
            }
            File dir = new File("/etc/");
            File[] fileList = new File[]{};
            if (dir.exists()) {
                fileList = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String filename) {
                        return filename.endsWith("-release");
                    }
                });
            }
            for (File f : fileList) {
                try {
                    BufferedReader myReader = new BufferedReader(new FileReader(f));
                    String strLine = null;
                    while ((strLine = myReader.readLine()) != null) {
                        if (strLine.contains("Red Hat Enterprise Linux Server release 7.")) {
                            return true;
                        }
                        if (!strLine.contains("CentOS Linux release 7.")) continue;
                        return true;
                    }
                    myReader.close();
                }
                catch (Exception e) {
                    System.err.println("Error: " + e.getMessage());
                }
            }
            return false;
        }
        catch (Exception e) {
            System.err.println(String.format("Could not detect EOL Linux Distribution because of the following error: %s", e.getMessage()));
            return false;
        }
    }

    private static String getResourcesPath() {
        String speechPrefix = "/ASSETS/%s%s/";
        String dataModelSize = System.getProperty("sun.arch.data.model");
        dataModelSize = dataModelSize != null && dataModelSize.equals("64") ? "64" : "32";
        if (operatingSystem.contains("linux")) {
            String osArchitecture = System.getProperty("os.arch");
            if (osArchitecture.contains("aarch64") || osArchitecture.contains("arm")) {
                return String.format(speechPrefix, "linux-arm", dataModelSize);
            }
            if (osArchitecture.contains("amd64") || osArchitecture.contains("x86_64")) {
                if (NativeLibraryLoader.useCentos7Binaries()) {
                    return String.format(speechPrefix, "centos7-x", dataModelSize);
                }
                return String.format(speechPrefix, "linux-x", dataModelSize);
            }
        } else {
            if (windowsOperatingSystem.booleanValue()) {
                loadAll = true;
                return String.format(speechPrefix, "windows", dataModelSize);
            }
            if (operatingSystem.contains("mac") || operatingSystem.contains("darwin")) {
                String osArchitecture = System.getProperty("os.arch");
                if (osArchitecture.contains("aarch64") || osArchitecture.contains("arm")) {
                    return String.format(speechPrefix, "osx-arm", dataModelSize);
                }
                if (osArchitecture.contains("amd64") || osArchitecture.contains("x86_64")) {
                    return String.format(speechPrefix, "osx-x", dataModelSize);
                }
            }
        }
        throw new UnsatisfiedLinkError(String.format("The Speech SDK doesn't currently have native support for operating system: %s data model size %s", operatingSystem, dataModelSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractResourceFromPath(NativeLibrary library, String prefix) throws IOException {
        String libName = library.getName();
        File temp = new File(tempDir.getCanonicalPath(), libName);
        if (!temp.getCanonicalPath().startsWith(tempDir.getCanonicalPath())) {
            throw new SecurityException("illegal name " + temp.getCanonicalPath());
        }
        temp.createNewFile();
        temp.deleteOnExit();
        if (!temp.exists()) {
            throw new FileNotFoundException(String.format("Temporary file %s could not be created. Make sure you can write to this location.", temp.getCanonicalPath()));
        }
        String path = prefix + libName;
        InputStream inStream = SpeechConfig.class.getResourceAsStream(path);
        if (inStream == null) {
            if (library.getRequired()) {
                throw new FileNotFoundException(String.format("Could not find resource %s in jar.", path));
            }
            return;
        }
        FileOutputStream outStream = null;
        byte[] buffer = new byte[0x100000];
        try {
            int bytesRead;
            outStream = new FileOutputStream(temp);
            while ((bytesRead = inStream.read(buffer)) >= 0) {
                outStream.write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            NativeLibraryLoader.safeClose(outStream);
            NativeLibraryLoader.safeClose(inStream);
            throw throwable;
        }
        NativeLibraryLoader.safeClose(outStream);
        NativeLibraryLoader.safeClose(inStream);
    }

    private static void copyLibraryFromPath(NativeLibrary library, String sourcePath) throws Exception {
        String libName = library.getName();
        File sourceFile = new File(sourcePath, libName);
        if (!sourceFile.exists()) {
            return;
        }
        File targetFile = new File(tempDir.getCanonicalPath(), libName);
        if (sourceFile.getCanonicalPath().equals(targetFile.getCanonicalPath())) {
            return;
        }
        targetFile.deleteOnExit();
        Files.copy(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private static void safeClose(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        extractionDone = false;
        loadAll = false;
        operatingSystem = ("" + System.getProperty("os.name")).toLowerCase();
        windowsOperatingSystem = operatingSystem.contains("windows");
        try {
            if (windowsOperatingSystem.booleanValue()) {
                File lockFile = Files.createTempFile(tempDirPrefix, lockFileExtension, new FileAttribute[0]).toFile();
                lockFile.createNewFile();
                lockFile.deleteOnExit();
                String tempDirName = lockFile.getAbsolutePath();
                tempDirName = tempDirName.substring(0, tempDirName.length() - lockFileExtension.length());
                tempDir = Files.createDirectory(Paths.get(tempDirName, new String[0]), new FileAttribute[0]).toFile();
                tempDir.deleteOnExit();
                Thread thread = new Thread(new DeleteUnlockedTempFolders());
                thread.start();
            } else {
                tempDir = Files.createTempDirectory(tempDirPrefix, new FileAttribute[0]).toFile();
                tempDir.deleteOnExit();
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private static class DeleteUnlockedTempFolders
    implements Runnable {
        private DeleteUnlockedTempFolders() {
        }

        @Override
        public void run() {
            FileFilter tmpDirFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith(NativeLibraryLoader.tempDirPrefix) && !pathname.getName().endsWith(NativeLibraryLoader.lockFileExtension);
                }
            };
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            File[] filteredDirList = tmpDir.listFiles(tmpDirFilter);
            for (int i = 0; i < filteredDirList.length; ++i) {
                File lockFile = new File(filteredDirList[i].getAbsolutePath() + NativeLibraryLoader.lockFileExtension);
                if (lockFile.exists()) continue;
                try {
                    Files.walkFileTree(Paths.get(filteredDirList[i].getAbsolutePath(), new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                filteredDirList[i].delete();
            }
        }
    }

    private static class NativeLibrary {
        private String name;
        private boolean required;

        public NativeLibrary(String name, boolean required) {
            this.name = name;
            this.required = required;
        }

        public String getName() {
            return this.name;
        }

        public boolean getRequired() {
            return this.required;
        }

        private void setName() {
            this.name = this.name;
        }

        private void setRequired() {
            this.required = this.required;
        }
    }
}

