/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PronunciationAssessmentGradingSystem;
import com.microsoft.cognitiveservices.speech.PronunciationAssessmentGranularity;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class PronunciationAssessmentConfig
implements AutoCloseable {
    private SafeHandle configHandle = null;
    private PropertyCollection propertyHandle = null;
    private boolean disposed = false;

    public PronunciationAssessmentConfig(String referenceText, PronunciationAssessmentGradingSystem gradingSystem, PronunciationAssessmentGranularity granularity, boolean enableMiscue) {
        IntRef pronAssessmentConfigRef = new IntRef(0L);
        Contracts.throwIfFail(PronunciationAssessmentConfig.create(pronAssessmentConfigRef, referenceText, gradingSystem.getValue(), granularity.getValue(), enableMiscue));
        this.init(pronAssessmentConfigRef.getValue());
    }

    public PronunciationAssessmentConfig(String referenceText, PronunciationAssessmentGradingSystem gradingSystem, PronunciationAssessmentGranularity granularity) {
        this(referenceText, gradingSystem, granularity, false);
    }

    public PronunciationAssessmentConfig(String referenceText) {
        this(referenceText, PronunciationAssessmentGradingSystem.FivePoint, PronunciationAssessmentGranularity.Phoneme);
    }

    public static PronunciationAssessmentConfig fromJson(String json) {
        IntRef pronAssessmentConfigRef = new IntRef(0L);
        Contracts.throwIfFail(PronunciationAssessmentConfig.fromJson(pronAssessmentConfigRef, json));
        return new PronunciationAssessmentConfig(pronAssessmentConfigRef.getValue());
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.propertyHandle != null) {
            this.propertyHandle.close();
            this.propertyHandle = null;
        }
        if (this.configHandle != null) {
            this.configHandle.close();
            this.configHandle = null;
        }
        this.disposed = true;
    }

    public void setReferenceText(String value) {
        Contracts.throwIfNull(value, "value");
        this.propertyHandle.setProperty(PropertyId.PronunciationAssessment_ReferenceText, value);
    }

    public String getReferenceText() {
        return this.propertyHandle.getProperty(PropertyId.PronunciationAssessment_ReferenceText);
    }

    public void setPhonemeAlphabet(String value) {
        Contracts.throwIfNull(value, "value");
        this.propertyHandle.setProperty(PropertyId.PronunciationAssessment_PhonemeAlphabet, value);
    }

    public void setNBestPhonemeCount(int count) {
        this.propertyHandle.setProperty(PropertyId.PronunciationAssessment_NBestPhonemeCount, String.valueOf(count));
    }

    public void enableProsodyAssessment() {
        this.propertyHandle.setProperty(PropertyId.PronunciationAssessment_EnableProsodyAssessment, "true");
    }

    public void enableContentAssessmentWithTopic(String topic) {
        Contracts.throwIfNull(topic, "topic");
        this.propertyHandle.setProperty(PropertyId.PronunciationAssessment_ContentTopic, topic);
    }

    public String toJson() {
        Contracts.throwIfNull(this.configHandle, "configHandle");
        return this.toJson(this.configHandle);
    }

    public void applyTo(Recognizer recognizer) {
        Contracts.throwIfNull(this.configHandle, "configHandle");
        Contracts.throwIfNull(recognizer, "recognizer");
        Contracts.throwIfNull(recognizer.getImpl(), "recoHandle");
        this.applyTo(this.configHandle, recognizer.getImpl());
    }

    public SafeHandle getImpl() {
        return this.configHandle;
    }

    private PronunciationAssessmentConfig(long handleValue) {
        this.init(handleValue);
    }

    private void init(long handleValue) {
        Contracts.throwIfNull(handleValue, "handleValue");
        this.configHandle = new SafeHandle(handleValue, SafeHandleType.PronunciationAssessmentConfig);
        IntRef propHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBag(this.configHandle, propHandle));
        this.propertyHandle = new PropertyCollection(propHandle);
    }

    private static final native long create(IntRef var0, String var1, int var2, int var3, boolean var4);

    private static final native long fromJson(IntRef var0, String var1);

    private final native long getPropertyBag(SafeHandle var1, IntRef var2);

    private final native long applyTo(SafeHandle var1, SafeHandle var2);

    private final native String toJson(SafeHandle var1);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

