/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.ContentAssessmentResult;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;

public final class PronunciationAssessmentResult {
    private double accuracyScore;
    private double pronunciationScore;
    private double completenessScore;
    private double fluencyScore;
    private double prosodyScore;
    private ContentAssessmentResult contentAssessmentResult;

    public static PronunciationAssessmentResult fromResult(SpeechRecognitionResult speechRecognitionResult) {
        Contracts.throwIfNull(speechRecognitionResult, "speechRecognitionResult cannot be null");
        if (speechRecognitionResult.getProperties().getProperty("AccuracyScore").isEmpty() && speechRecognitionResult.getProperties().getProperty("ContentAssessment_GrammarScore").isEmpty()) {
            return null;
        }
        return new PronunciationAssessmentResult(speechRecognitionResult.getProperties());
    }

    public Double getAccuracyScore() {
        return this.accuracyScore;
    }

    public Double getPronunciationScore() {
        return this.pronunciationScore;
    }

    public Double getCompletenessScore() {
        return this.completenessScore;
    }

    public Double getFluencyScore() {
        return this.fluencyScore;
    }

    public Double getProsodyScore() {
        return this.prosodyScore >= 0.0 ? Double.valueOf(this.prosodyScore) : null;
    }

    public ContentAssessmentResult getContentAssessmentResult() {
        return this.contentAssessmentResult;
    }

    private PronunciationAssessmentResult(PropertyCollection properties) {
        this.accuracyScore = Double.parseDouble(properties.getProperty("AccuracyScore", "-1"));
        this.pronunciationScore = Double.parseDouble(properties.getProperty("PronScore", "-1"));
        this.completenessScore = Double.parseDouble(properties.getProperty("CompletenessScore", "-1"));
        this.fluencyScore = Double.parseDouble(properties.getProperty("FluencyScore", "-1"));
        this.prosodyScore = Double.parseDouble(properties.getProperty("ProsodyScore", "-1"));
        if (!properties.getProperty("ContentAssessment_GrammarScore").isEmpty()) {
            this.contentAssessmentResult = new ContentAssessmentResult(properties);
        }
    }
}

