/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public class SessionEventArgs {
    protected SafeHandle eventHandle = null;
    private String sessionId;
    private final int maxUUID = 36;
    private final int maxSessionID = 37;

    public SessionEventArgs(long eventArgs) {
        Contracts.throwIfNull(eventArgs, "eventArgs");
        this.eventHandle = new SafeHandle(eventArgs, SafeHandleType.Event);
        this.storeEventData(false);
    }

    public SessionEventArgs(long eventArgs, boolean dispose) {
        Contracts.throwIfNull(eventArgs, "eventArgs");
        this.eventHandle = new SafeHandle(eventArgs, SafeHandleType.Event);
        this.storeEventData(dispose);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        return "SessionId: " + this.sessionId + ".";
    }

    protected void close() {
        if (this.eventHandle != null) {
            this.eventHandle.close();
            this.eventHandle = null;
        }
    }

    private void storeEventData(boolean disposeNativeResources) {
        StringRef sessionIdRef = new StringRef("");
        Contracts.throwIfFail(this.getSessionId(this.eventHandle, sessionIdRef, 37));
        this.sessionId = sessionIdRef.getValue();
        Contracts.throwIfNull(this.sessionId, "SessionId");
        if (disposeNativeResources) {
            this.close();
        }
    }

    private final native long getSessionId(SafeHandle var1, StringRef var2, int var3);
}

