/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.AudioDataStream;
import com.microsoft.cognitiveservices.speech.CancellationErrorCode;
import com.microsoft.cognitiveservices.speech.CancellationReason;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public class SpeechSynthesisCancellationDetails {
    private CancellationReason reason;
    private String errorDetails;
    private CancellationErrorCode errorCode;

    public static SpeechSynthesisCancellationDetails fromResult(SpeechSynthesisResult result) {
        return new SpeechSynthesisCancellationDetails(result);
    }

    public static SpeechSynthesisCancellationDetails fromStream(AudioDataStream stream) {
        return new SpeechSynthesisCancellationDetails(stream);
    }

    private SpeechSynthesisCancellationDetails(SpeechSynthesisResult result) {
        Contracts.throwIfNull(result, "result");
        Contracts.throwIfNull(result.getImpl(), "resultHandle");
        IntRef valueRef = new IntRef(0L);
        Contracts.throwIfFail(this.getCanceledReasonFromSynthResult(result.getImpl(), valueRef));
        this.reason = CancellationReason.values()[(int)valueRef.getValue() - 1];
        Contracts.throwIfFail(this.getCanceledErrorCodeFromSynthResult(result.getImpl(), valueRef));
        this.errorCode = CancellationErrorCode.values()[(int)valueRef.getValue()];
        this.errorDetails = result.getProperties().getProperty(PropertyId.CancellationDetails_ReasonDetailedText);
    }

    private SpeechSynthesisCancellationDetails(AudioDataStream stream) {
        Contracts.throwIfNull(stream, "stream");
        Contracts.throwIfNull(stream.getImpl(), "streamHandle");
        IntRef valueRef = new IntRef(0L);
        Contracts.throwIfFail(this.getCanceledReasonFromStream(stream.getImpl(), valueRef));
        this.reason = CancellationReason.values()[(int)valueRef.getValue() - 1];
        Contracts.throwIfFail(this.getCanceledErrorCodeFromStream(stream.getImpl(), valueRef));
        this.errorCode = CancellationErrorCode.values()[(int)valueRef.getValue()];
        this.errorDetails = stream.getProperties().getProperty(PropertyId.CancellationDetails_ReasonDetailedText);
    }

    public void close() {
    }

    public CancellationReason getReason() {
        return this.reason;
    }

    public CancellationErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "CancellationReason:" + (Object)((Object)this.reason) + " ErrorCode: " + (Object)((Object)this.errorCode) + " ErrorDetails:" + this.errorDetails;
    }

    private final native long getCanceledReasonFromSynthResult(SafeHandle var1, IntRef var2);

    private final native long getCanceledErrorCodeFromSynthResult(SafeHandle var1, IntRef var2);

    private final native long getCanceledReasonFromStream(SafeHandle var1, IntRef var2);

    private final native long getCanceledErrorCodeFromStream(SafeHandle var1, IntRef var2);
}

