/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.intent;

import com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig;
import com.microsoft.cognitiveservices.speech.KeywordRecognitionModel;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.intent.IntentRecognitionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.intent.IntentRecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.intent.IntentRecognitionResult;
import com.microsoft.cognitiveservices.speech.intent.IntentTrigger;
import com.microsoft.cognitiveservices.speech.intent.LanguageUnderstandingModel;
import com.microsoft.cognitiveservices.speech.intent.PatternMatchingEntity;
import com.microsoft.cognitiveservices.speech.intent.PatternMatchingIntent;
import com.microsoft.cognitiveservices.speech.intent.PatternMatchingModel;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class IntentRecognizer
extends Recognizer {
    public final EventHandlerImpl<IntentRecognitionEventArgs> recognizing;
    public final EventHandlerImpl<IntentRecognitionEventArgs> recognized;
    public final EventHandlerImpl<IntentRecognitionCanceledEventArgs> canceled;
    static Set<IntentRecognizer> intentRecognizerObjects = Collections.synchronizedSet(new HashSet());
    private PropertyCollection propertyHandle;

    public IntentRecognizer(SpeechConfig speechConfig) {
        super(null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        Contracts.throwIfFail(this.createIntentRecognizerFromConfig(super.getImpl(), speechConfig.getImpl(), null));
        this.initialize();
    }

    public IntentRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig) {
        super(null);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(embeddedSpeechConfig, "embeddedSpeechConfig");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        Contracts.throwIfFail(this.createIntentRecognizerFromConfig(super.getImpl(), embeddedSpeechConfig.getImpl(), null));
        this.initialize();
    }

    public IntentRecognizer(SpeechConfig speechConfig, AudioConfig audioConfig) {
        super(audioConfig);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(speechConfig, "speechConfig");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createIntentRecognizerFromConfig(super.getImpl(), speechConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createIntentRecognizerFromConfig(super.getImpl(), speechConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public IntentRecognizer(EmbeddedSpeechConfig embeddedSpeechConfig, AudioConfig audioConfig) {
        super(audioConfig);
        this.recognizing = new EventHandlerImpl(this.eventCounter);
        this.recognized = new EventHandlerImpl(this.eventCounter);
        this.canceled = new EventHandlerImpl(this.eventCounter);
        this.propertyHandle = null;
        Contracts.throwIfNull(embeddedSpeechConfig, "embeddedSpeechConfig");
        Contracts.throwIfNull(super.getImpl(), "recoHandle");
        if (audioConfig == null) {
            Contracts.throwIfFail(this.createIntentRecognizerFromConfig(super.getImpl(), embeddedSpeechConfig.getImpl(), null));
        } else {
            Contracts.throwIfFail(this.createIntentRecognizerFromConfig(super.getImpl(), embeddedSpeechConfig.getImpl(), audioConfig.getImpl()));
        }
        this.initialize();
    }

    public String getSpeechRecognitionLanguage() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceConnection_RecoLanguage);
    }

    public void setAuthorizationToken(String token) {
        Contracts.throwIfNullOrWhitespace(token, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, token);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<IntentRecognitionResult> recognizeOnceAsync() {
        final IntentRecognizer thisReco = this;
        return AsyncThreadService.submit(new Callable<IntentRecognitionResult>(){

            @Override
            public IntentRecognitionResult call() {
                final IntentRecognitionResult[] result = new IntentRecognitionResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        result[0] = new IntentRecognitionResult(thisReco.recognize());
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return result[0];
            }
        });
    }

    public Future<IntentRecognitionResult> recognizeOnceAsync(String text) {
        final IntentRecognizer thisReco = this;
        final String thisText = text;
        return AsyncThreadService.submit(new Callable<IntentRecognitionResult>(){

            @Override
            public IntentRecognitionResult call() {
                final IntentRecognitionResult[] result = new IntentRecognitionResult[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IntRef resultRef = new IntRef(0L);
                        Contracts.throwIfNull(thisReco, "Invalid recognizer handle");
                        Contracts.throwIfFail(IntentRecognizer.this.recognizeTextOnce(thisReco.getImpl(), thisText, resultRef));
                        result[0] = new IntentRecognitionResult(resultRef.getValue());
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return result[0];
            }
        });
    }

    public Future<Void> startContinuousRecognitionAsync() {
        final IntentRecognizer thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        thisReco.startContinuousRecognition(IntentRecognizer.this.getImpl());
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopContinuousRecognitionAsync() {
        final IntentRecognizer thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        thisReco.stopContinuousRecognition(IntentRecognizer.this.getImpl());
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public void addIntent(String simplePhrase) {
        Contracts.throwIfNullOrWhitespace(simplePhrase, "simplePhrase");
        IntentTrigger trigger = IntentTrigger.fromPhrase(simplePhrase);
        Contracts.throwIfFail(this.addIntent(super.getImpl(), simplePhrase, trigger.getImpl()));
    }

    public void addIntent(String simplePhrase, String intentId) {
        Contracts.throwIfNullOrWhitespace(simplePhrase, "simplePhrase");
        Contracts.throwIfNullOrWhitespace(intentId, "intentId");
        IntentTrigger trigger = IntentTrigger.fromPhrase(simplePhrase);
        Contracts.throwIfFail(this.addIntent(super.getImpl(), intentId, trigger.getImpl()));
    }

    public void addIntent(LanguageUnderstandingModel model, String intentName) {
        Contracts.throwIfNull(model, "model");
        Contracts.throwIfNullOrWhitespace(intentName, "intentName");
        IntentTrigger trigger = IntentTrigger.fromModel(model.getImpl(), intentName);
        Contracts.throwIfFail(this.addIntent(super.getImpl(), intentName, trigger.getImpl()));
    }

    public void addIntent(LanguageUnderstandingModel model, String intentName, String intentId) {
        Contracts.throwIfNull(model, "model");
        Contracts.throwIfNullOrWhitespace(intentName, "intentName");
        Contracts.throwIfNullOrWhitespace(intentId, "intentId");
        IntentTrigger trigger = IntentTrigger.fromModel(model.getImpl(), intentName);
        Contracts.throwIfFail(this.addIntent(super.getImpl(), intentId, trigger.getImpl()));
    }

    public void addAllIntents(LanguageUnderstandingModel model, String intentId) {
        Contracts.throwIfNull(model, "model");
        Contracts.throwIfNullOrWhitespace(intentId, "intentId");
        IntentTrigger trigger = IntentTrigger.fromModel(model.getImpl());
        Contracts.throwIfFail(this.addIntent(super.getImpl(), intentId, trigger.getImpl()));
    }

    public void addAllIntents(LanguageUnderstandingModel model) {
        Contracts.throwIfNull(model, "model");
        IntentTrigger trigger = IntentTrigger.fromModel(model.getImpl());
        Contracts.throwIfFail(this.addIntent(super.getImpl(), null, trigger.getImpl()));
    }

    public Future<Void> startKeywordRecognitionAsync(KeywordRecognitionModel model) {
        Contracts.throwIfNull(model, "model");
        final IntentRecognizer thisReco = this;
        final KeywordRecognitionModel model2 = model;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        thisReco.startKeywordRecognition(IntentRecognizer.this.getImpl(), model2.getImpl());
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> stopKeywordRecognitionAsync() {
        final IntentRecognizer thisReco = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        thisReco.stopKeywordRecognition(IntentRecognizer.this.getImpl());
                    }
                };
                thisReco.doAsyncRecognitionAction(runnable);
                return null;
            }
        });
    }

    public boolean applyLanguageModels(Collection<LanguageUnderstandingModel> collection) throws NullPointerException {
        Contracts.throwIfNull(collection, "collection");
        boolean result = true;
        Contracts.throwIfFail(this.clearLanguageModels(super.getImpl()));
        for (LanguageUnderstandingModel model : collection) {
            Contracts.throwIfNull(model, "model");
            if (model instanceof PatternMatchingModel) {
                this.applyPatternMatchingModel((PatternMatchingModel)model);
                continue;
            }
            if (!(model instanceof LanguageUnderstandingModel)) continue;
            IntentTrigger intentTrigger = IntentTrigger.fromModel(model.getImpl());
            Contracts.throwIfFail(this.addIntent(super.getImpl(), null, intentTrigger.getImpl()));
            result = false;
        }
        return result;
    }

    @Override
    protected void dispose(boolean disposing) {
        if (this.disposed) {
            return;
        }
        if (disposing) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            intentRecognizerObjects.remove(this);
            super.dispose(disposing);
        }
    }

    private void initialize() {
        final IntentRecognizer _this = this;
        this.recognizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(_this);
                Contracts.throwIfFail(IntentRecognizer.this.recognizingSetCallback(_this.getImpl().getValue()));
            }
        });
        this.recognized.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(_this);
                Contracts.throwIfFail(IntentRecognizer.this.recognizedSetCallback(_this.getImpl().getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(_this);
                Contracts.throwIfFail(IntentRecognizer.this.canceledSetCallback(_this.getImpl().getValue()));
            }
        });
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(_this);
                Contracts.throwIfFail(IntentRecognizer.this.sessionStartedSetCallback(_this.getImpl().getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(_this);
                Contracts.throwIfFail(IntentRecognizer.this.sessionStoppedSetCallback(_this.getImpl().getValue()));
            }
        });
        this.speechStartDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(_this);
                Contracts.throwIfFail(IntentRecognizer.this.speechStartDetectedSetCallback(_this.getImpl().getValue()));
            }
        });
        this.speechEndDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                intentRecognizerObjects.add(_this);
                Contracts.throwIfFail(IntentRecognizer.this.speechEndDetectedSetCallback(_this.getImpl().getValue()));
            }
        });
        IntRef propHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromRecognizerHandle(_this.getImpl(), propHandle));
        this.propertyHandle = new PropertyCollection(propHandle);
    }

    private void recognizingEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            IntentRecognitionEventArgs resultEventArg = new IntentRecognitionEventArgs(eventArgs, true);
            EventHandlerImpl<IntentRecognitionEventArgs> handler = this.recognizing;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recognizedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            IntentRecognitionEventArgs resultEventArg = new IntentRecognitionEventArgs(eventArgs, true);
            EventHandlerImpl<IntentRecognitionEventArgs> handler = this.recognized;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "recognizer");
            if (this.disposed) {
                return;
            }
            IntentRecognitionCanceledEventArgs resultEventArg = new IntentRecognitionCanceledEventArgs(eventArgs, true);
            EventHandlerImpl<IntentRecognitionCanceledEventArgs> handler = this.canceled;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void applyPatternMatchingModel(PatternMatchingModel simpleModel) {
        try (SafeHandle modelHandle = new SafeHandle(0L, SafeHandleType.LanguageUnderstandingModel);){
            Contracts.throwIfFail(this.createPatternMatchingModel(modelHandle, super.getImpl(), simpleModel.getId()));
            for (PatternMatchingIntent intent : simpleModel.getIntents().values()) {
                Contracts.throwIfFail(this.patternMatchingModelAddIntent(modelHandle, intent.getId(), 0, intent.Phrases.toArray(new String[0])));
            }
            for (PatternMatchingEntity entity : simpleModel.getEntities().values()) {
                Contracts.throwIfFail(this.patternMatchingModelAddEntity(modelHandle, entity.getId(), entity.getType().getValue(), entity.getMatchMode().getValue(), entity.Phrases.toArray(new String[0])));
            }
            try (IntentTrigger trigger = IntentTrigger.fromModel(modelHandle);){
                Contracts.throwIfFail(this.addIntentWithModelId(super.getImpl(), trigger.getImpl(), simpleModel.getId()));
            }
        }
    }

    private final native long addIntent(SafeHandle var1, String var2, SafeHandle var3);

    private final native long clearLanguageModels(SafeHandle var1);

    private final native long createIntentRecognizerFromConfig(SafeHandle var1, SafeHandle var2, SafeHandle var3);

    private final native long importPatternMatchingModel(SafeHandle var1, String var2);

    private final native long recognizeTextOnce(SafeHandle var1, String var2, IntRef var3);

    private final native long createPatternMatchingModel(SafeHandle var1, SafeHandle var2, String var3);

    private final native long patternMatchingModelAddEntity(SafeHandle var1, String var2, int var3, int var4, String[] var5);

    private final native long patternMatchingModelAddIntent(SafeHandle var1, String var2, int var3, String[] var4);

    private final native long addIntentWithModelId(SafeHandle var1, SafeHandle var2, String var3);
}

