/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.speaker;

import com.microsoft.cognitiveservices.speech.speaker.VoiceProfileType;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public final class VoiceProfile
implements AutoCloseable {
    private SafeHandle voiceProfileHandle = null;
    private boolean disposed = false;

    public VoiceProfile(String id, VoiceProfileType type) {
        IntRef result = new IntRef(0L);
        Contracts.throwIfFail(this.createVoiceProfileFromIdAndType(id, type.getValue(), result));
        this.voiceProfileHandle = new SafeHandle(result.getValue(), SafeHandleType.VoiceProfile);
    }

    public VoiceProfile(long handle) {
        Contracts.throwIfNull(handle, "handle");
        this.voiceProfileHandle = new SafeHandle(handle, SafeHandleType.VoiceProfile);
    }

    public String getId() {
        StringRef result = new StringRef("");
        Contracts.throwIfFail(this.getId(this.voiceProfileHandle, result));
        return result.getValue();
    }

    public VoiceProfileType getType() {
        IntRef result = new IntRef(0L);
        Contracts.throwIfFail(this.getType(this.voiceProfileHandle, result));
        return VoiceProfileType.values()[(int)result.getValue() - 1];
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.voiceProfileHandle != null) {
            this.voiceProfileHandle.close();
            this.voiceProfileHandle = null;
        }
        this.disposed = true;
    }

    public SafeHandle getImpl() {
        return this.voiceProfileHandle;
    }

    private final native long createVoiceProfileFromIdAndType(String var1, int var2, IntRef var3);

    private final native long getId(SafeHandle var1, StringRef var2);

    private final native long getType(SafeHandle var1, IntRef var2);
}

