/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.transcription.Participant;
import com.microsoft.cognitiveservices.speech.transcription.User;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public final class Conversation
implements AutoCloseable {
    private SafeHandle conversationHandle;
    private boolean disposed = false;
    private final Object conversationLock = new Object();
    private int activeAsyncConversationCounter = 0;
    private PropertyCollection propertyHandle;

    public static Future<Conversation> createConversationAsync(SpeechConfig speechConfig) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        String finalConversationId = "";
        final SpeechConfig finalSpeechConfig = speechConfig;
        AsyncThreadService.initialize();
        return AsyncThreadService.submit(new Callable<Conversation>(){

            @Override
            public Conversation call() {
                IntRef handleRef = new IntRef(0L);
                Contracts.throwIfFail(Conversation.createConversationFromConfig(handleRef, finalSpeechConfig.getImpl(), ""));
                return new Conversation(handleRef.getValue());
            }
        });
    }

    public static Future<Conversation> createConversationAsync(SpeechConfig speechConfig, String conversationId) {
        Contracts.throwIfNull(speechConfig, "speechConfig");
        Contracts.throwIfNull(conversationId, "conversationId");
        final String finalConversationId = conversationId;
        final SpeechConfig finalSpeechConfig = speechConfig;
        AsyncThreadService.initialize();
        return AsyncThreadService.submit(new Callable<Conversation>(){

            @Override
            public Conversation call() {
                IntRef handleRef = new IntRef(0L);
                Contracts.throwIfFail(Conversation.createConversationFromConfig(handleRef, finalSpeechConfig.getImpl(), finalConversationId));
                return new Conversation(handleRef.getValue());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.conversationLock;
        synchronized (object) {
            if (this.activeAsyncConversationCounter != 0) {
                throw new IllegalStateException("Cannot dispose a recognizer while async recognition is running. Await async recognitions to avoid unexpected disposals.");
            }
            this.dispose(true);
        }
    }

    public String getConversationId() {
        StringRef conversationIdRef = new StringRef("");
        Contracts.throwIfFail(this.getConversationId(this.conversationHandle, conversationIdRef));
        return conversationIdRef.getValue();
    }

    public void setAuthorizationToken(String token) {
        Contracts.throwIfNullOrWhitespace(token, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, token);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<Participant> addParticipantAsync(Participant participant) {
        final Participant finalParticipant = participant;
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Participant>(){

            @Override
            public Participant call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.addParticipant(Conversation.this.conversationHandle, finalParticipant.getImpl()));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return finalParticipant;
            }
        });
    }

    public Future<Participant> addParticipantAsync(final String userId) {
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Participant>(){

            @Override
            public Participant call() {
                final Participant[] result = new Participant[1];
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Participant participant = Participant.from(userId);
                        Contracts.throwIfFail(Conversation.this.addParticipant(Conversation.this.conversationHandle, participant.getImpl()));
                        result[0] = participant;
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return result[0];
            }
        });
    }

    public Future<User> addParticipantAsync(final User user) {
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<User>(){

            @Override
            public User call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.addParticipantByUser(Conversation.this.conversationHandle, user.getImpl()));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return user;
            }
        });
    }

    public Future<Void> removeParticipantAsync(User user) {
        final User finalUser = user;
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.removeParticipantByUser(Conversation.this.conversationHandle, finalUser.getImpl()));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> removeParticipantAsync(Participant participant) {
        final Participant finalParticipant = participant;
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.removeParticipant(Conversation.this.conversationHandle, finalParticipant.getImpl()));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> removeParticipantAsync(String userId) {
        final String finalUserId = userId;
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.removeParticipantByUserId(Conversation.this.conversationHandle, finalUserId));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> endConversationAsync() {
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.endConversation(Conversation.this.conversationHandle));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> startConversationAsync() {
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.startConversation(Conversation.this.conversationHandle));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> deleteConversationAsync() {
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.deleteConversation(Conversation.this.conversationHandle));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> lockConversationAsync() {
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.lockConversation(Conversation.this.conversationHandle));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> unlockConversationAsync() {
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.unlockConversation(Conversation.this.conversationHandle));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> muteAllParticipantsAsync() {
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.muteAll(Conversation.this.conversationHandle));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> unmuteAllParticipantsAsync() {
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.unmuteAll(Conversation.this.conversationHandle));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> muteParticipantAsync(String userId) {
        final String finalUserId = userId;
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.muteParticipant(Conversation.this.conversationHandle, finalUserId));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public Future<Void> unmuteParticipantAsync(String userId) {
        final String finalUserId = userId;
        final Conversation thisConv = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Contracts.throwIfFail(Conversation.this.unmuteParticipant(Conversation.this.conversationHandle, finalUserId));
                    }
                };
                thisConv.doAsyncConversationAction(runnable);
                return null;
            }
        });
    }

    public SafeHandle getImpl() {
        return this.conversationHandle;
    }

    protected void dispose(boolean disposing) {
        if (this.disposed) {
            return;
        }
        if (disposing) {
            if (this.conversationHandle != null) {
                this.conversationHandle.close();
                this.conversationHandle = null;
            }
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    protected Conversation(long handleValue) {
        this.conversationHandle = new SafeHandle(handleValue, SafeHandleType.Conversation);
        IntRef propbagRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBag(this.conversationHandle, propbagRef));
        this.propertyHandle = new PropertyCollection(propbagRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncConversationAction(Runnable conversationImplAction) {
        Object object = this.conversationLock;
        synchronized (object) {
            ++this.activeAsyncConversationCounter;
        }
        if (this.disposed) {
            throw new IllegalStateException(this.getClass().getName());
        }
        try {
            conversationImplAction.run();
        }
        finally {
            object = this.conversationLock;
            synchronized (object) {
                --this.activeAsyncConversationCounter;
            }
        }
    }

    private static final native long createConversationFromConfig(IntRef var0, SafeHandle var1, String var2);

    private final native long getConversationId(SafeHandle var1, StringRef var2);

    private final native long addParticipant(SafeHandle var1, SafeHandle var2);

    private final native long addParticipantByUser(SafeHandle var1, SafeHandle var2);

    private final native long removeParticipant(SafeHandle var1, SafeHandle var2);

    private final native long removeParticipantByUser(SafeHandle var1, SafeHandle var2);

    private final native long removeParticipantByUserId(SafeHandle var1, String var2);

    private final native long startConversation(SafeHandle var1);

    private final native long endConversation(SafeHandle var1);

    private final native long deleteConversation(SafeHandle var1);

    private final native long lockConversation(SafeHandle var1);

    private final native long unlockConversation(SafeHandle var1);

    private final native long muteParticipant(SafeHandle var1, String var2);

    private final native long muteAll(SafeHandle var1);

    private final native long unmuteParticipant(SafeHandle var1, String var2);

    private final native long unmuteAll(SafeHandle var1);

    private final native long getPropertyBag(SafeHandle var1, IntRef var2);
}

