/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import java.net.URI;
import java.util.ArrayList;

public final class SpeechTranslationConfig
extends SpeechConfig
implements AutoCloseable {
    private boolean disposed = false;

    private SpeechTranslationConfig(long handleValue) {
        super(handleValue);
    }

    public static SpeechTranslationConfig fromSubscription(String subscriptionKey, String region) {
        Contracts.throwIfIllegalSubscriptionKey(subscriptionKey, "subscriptionKey");
        Contracts.throwIfNullOrWhitespace(region, "region");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechTranslationConfig.fromSubscription(configRef, subscriptionKey, region));
        return new SpeechTranslationConfig(configRef.getValue());
    }

    public static SpeechTranslationConfig fromAuthorizationToken(String authorizationToken, String region) {
        Contracts.throwIfNullOrWhitespace(authorizationToken, "authorizationToken");
        Contracts.throwIfNullOrWhitespace(region, "region");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechTranslationConfig.fromAuthorizationToken(configRef, authorizationToken, region));
        return new SpeechTranslationConfig(configRef.getValue());
    }

    public static SpeechTranslationConfig fromEndpoint(URI endpoint, String subscriptionKey) {
        Contracts.throwIfNull(endpoint, "endpoint");
        if (subscriptionKey == null) {
            throw new NullPointerException("subscriptionKey");
        }
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechTranslationConfig.fromEndpoint(configRef, endpoint.toString(), subscriptionKey));
        return new SpeechTranslationConfig(configRef.getValue());
    }

    public static SpeechTranslationConfig fromEndpoint(URI endpoint) {
        Contracts.throwIfNull(endpoint, "endpoint");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechTranslationConfig.fromEndpoint(configRef, endpoint.toString(), null));
        return new SpeechTranslationConfig(configRef.getValue());
    }

    public static SpeechTranslationConfig fromHost(URI host, String subscriptionKey) {
        Contracts.throwIfNull(host, "host");
        if (subscriptionKey == null) {
            throw new NullPointerException("subscriptionKey");
        }
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechTranslationConfig.fromHost(configRef, host.toString(), subscriptionKey));
        return new SpeechTranslationConfig(configRef.getValue());
    }

    public static SpeechTranslationConfig fromHost(URI host) {
        Contracts.throwIfNull(host, "host");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(SpeechTranslationConfig.fromHost(configRef, host.toString(), null));
        return new SpeechTranslationConfig(configRef.getValue());
    }

    public void addTargetLanguage(String value) {
        Contracts.throwIfNullOrWhitespace(value, "value");
        Contracts.throwIfFail(this.addTargetLanguage(super.getImpl(), value));
    }

    public void removeTargetLanguage(String value) {
        Contracts.throwIfNullOrWhitespace(value, "value");
        Contracts.throwIfFail(this.removeTargetLanguage(super.getImpl(), value));
    }

    public ArrayList<String> getTargetLanguages() {
        ArrayList<String> result = new ArrayList<String>();
        String plainStr = this.getProperty(PropertyId.SpeechServiceConnection_TranslationToLanguages);
        String[] values = plainStr.split(",");
        for (int i = 0; i < values.length; ++i) {
            result.add(values[i]);
        }
        return result;
    }

    public String getVoiceName() {
        return this.getProperty(PropertyId.SpeechServiceConnection_TranslationVoice);
    }

    public void setVoiceName(String value) {
        Contracts.throwIfNullOrWhitespace(value, "value");
        this.setProperty(PropertyId.SpeechServiceConnection_TranslationVoice, value);
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        super.close();
        this.disposed = true;
    }

    @Override
    public SafeHandle getImpl() {
        return super.getImpl();
    }

    private static final native long fromSubscription(IntRef var0, String var1, String var2);

    private static final native long fromAuthorizationToken(IntRef var0, String var1, String var2);

    private static final native long fromEndpoint(IntRef var0, String var1, String var2);

    private static final native long fromHost(IntRef var0, String var1, String var2);

    private final native long addTargetLanguage(SafeHandle var1, String var2);

    private final native long removeTargetLanguage(SafeHandle var1, String var2);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

