/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.microsoft.cognitiveservices.speech.RecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.translation.TranslationRecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;

public class TranslationRecognitionEventArgs
extends RecognitionEventArgs {
    private TranslationRecognitionResult result;

    TranslationRecognitionEventArgs(long eventArgs) {
        super(eventArgs);
        this.storeEventData(false);
    }

    TranslationRecognitionEventArgs(long eventArgs, boolean dispose) {
        super(eventArgs);
        this.storeEventData(dispose);
    }

    public final TranslationRecognitionResult getResult() {
        return this.result;
    }

    @Override
    public String toString() {
        String text = "TranslationRecognitionResult " + super.toString();
        for (String key : this.result.getTranslations().keySet()) {
            text = text + "    Translation in " + key + ": <" + this.result.getTranslations().get(key) + ">.\n";
        }
        return text;
    }

    private void storeEventData(boolean disposeNativeResources) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        IntRef resultHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getRecognitionResult(this.eventHandle, resultHandle));
        this.result = new TranslationRecognitionResult(resultHandle.getValue());
        Contracts.throwIfNull(this.getSessionId(), "SessionId");
        if (disposeNativeResources) {
            super.close();
        }
    }
}

