/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.translation;

import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class TranslationSynthesisResult {
    private byte[] audioData;
    private SafeHandle resultHandle;
    private ResultReason reason;

    TranslationSynthesisResult(long result) {
        Contracts.throwIfNull(result, "result");
        this.resultHandle = new SafeHandle(result, SafeHandleType.RecognitionResult);
        IntRef intVal = new IntRef(0L);
        Contracts.throwIfFail(this.getResultReason(this.resultHandle, intVal));
        this.reason = ResultReason.values()[(int)intVal.getValue()];
        IntRef hr = new IntRef(0L);
        this.audioData = this.getAudio(this.resultHandle, hr);
        Contracts.throwIfFail(hr.getValue());
    }

    public void close() {
        if (this.resultHandle != null) {
            this.resultHandle.close();
        }
        this.resultHandle = null;
    }

    public ResultReason getReason() {
        return this.reason;
    }

    public byte[] getAudio() {
        return this.audioData;
    }

    public String toString() {
        return "TranslationSynthesisResult Reason:" + (Object)((Object)this.reason) + " Audio.length:" + this.audioData.length + ".";
    }

    private final native long getResultReason(SafeHandle var1, IntRef var2);

    private final native byte[] getAudio(SafeHandle var1, IntRef var2);
}

