/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.auth;

import com.microsoft.graph.auth.enums.NationalCloud;
import java.util.HashMap;
import java.util.List;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.message.types.GrantType;

public class BaseAuthentication {
    private List<String> scopes;
    private String clientId;
    private String authority;
    private String clientSecret;
    private long startTime;
    private NationalCloud nationalCloud;
    private String tenant;
    private String redirectUri = "https://localhost:8080";
    private OAuthJSONAccessTokenResponse response;
    protected static HashMap<String, String> CloudList = new HashMap<String, String>(){
        {
            this.put("Global", "https://login.microsoftonline.com/");
            this.put("China", "https://login.chinacloudapi.cn/");
            this.put("Germany", "https://login.microsoftonline.de/");
            this.put("UsGovernment", "https://login.microsoftonline.us/");
        }
    };

    public BaseAuthentication(List<String> scopes, String clientId, String authority, String redirectUri, NationalCloud nationalCloud, String tenant, String clientSecret) {
        this.scopes = scopes;
        this.clientId = clientId;
        this.authority = authority;
        this.redirectUri = redirectUri;
        this.nationalCloud = nationalCloud;
        this.tenant = tenant;
        this.clientSecret = clientSecret;
    }

    protected static String GetAuthority(NationalCloud authorityEndpoint, String tenant) {
        return CloudList.get(authorityEndpoint.toString()) + tenant;
    }

    protected String getScopesAsString() {
        StringBuilder scopeString = new StringBuilder();
        for (String s : this.scopes) {
            scopeString.append(s);
            scopeString.append(" ");
        }
        return scopeString.toString();
    }

    protected String getAccessTokenSilent() {
        long durationPassed = System.currentTimeMillis() - this.startTime;
        if (this.response == null || durationPassed < 0L) {
            return null;
        }
        try {
            if (durationPassed >= this.response.getExpiresIn() * 1000L) {
                OAuthClientRequest.TokenRequestBuilder token = OAuthClientRequest.tokenLocation((String)(this.authority + "/oauth2/v2.0/token")).setClientId(this.clientId).setScope(this.getScopesAsString()).setRefreshToken(this.response.getRefreshToken()).setGrantType(GrantType.REFRESH_TOKEN).setScope(this.getScopesAsString()).setRedirectURI(this.redirectUri);
                if (this.clientSecret != null) {
                    token.setClientSecret(this.clientSecret);
                }
                OAuthClientRequest request = token.buildBodyMessage();
                OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
                this.startTime = System.currentTimeMillis();
                this.response = oAuthClient.accessToken(request);
                return this.response.getAccessToken();
            }
            return this.response.getAccessToken();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getAuthority() {
        return this.authority;
    }

    protected String getClientId() {
        return this.clientId;
    }

    protected String getClientSecret() {
        return this.clientSecret;
    }

    protected String getRedirectUri() {
        return this.redirectUri;
    }

    protected void setResponse(OAuthJSONAccessTokenResponse response) {
        this.response = response;
    }

    protected OAuthJSONAccessTokenResponse getResponse() {
        return this.response;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    protected NationalCloud getNationalCloud() {
        return this.nationalCloud;
    }

    protected String getTenant() {
        return this.tenant;
    }
}

