/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.httpcore;

import com.microsoft.graph.httpcore.middlewareoption.MiddlewareType;
import com.microsoft.graph.httpcore.middlewareoption.TelemetryOptions;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ChaosHttpHandler
implements Interceptor {
    public final MiddlewareType MIDDLEWARE_TYPE = MiddlewareType.RETRY;
    private final String RETRY_AFTER = "Retry-After";
    private final Integer failureRate = 3;
    private final String retryAfterValue = "10";
    private final String responseBody = "{\"error\": {\"code\": \"TooManyRequests\",\"innerError\": {\"code\": \"429\",\"date\": \"2020-08-18T12:51:51\",\"message\": \"Please retry after\",\"request-id\": \"94fb3b52-452a-4535-a601-69e0a90e3aa2\",\"status\": \"429\"},\"message\": \"Please retry again later.\"}}";
    public static final int MSClientErrorCodeTooManyRequests = 429;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (request.tag(TelemetryOptions.class) == null) {
            request = request.newBuilder().tag(TelemetryOptions.class, (Object)new TelemetryOptions()).build();
        }
        ((TelemetryOptions)request.tag(TelemetryOptions.class)).setFeatureUsage(2);
        Integer dice = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        if (dice % this.failureRate == 0) {
            return new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(429).message("Too Many Requests").addHeader("Retry-After", "10").body(ResponseBody.create((MediaType)MediaType.get((String)"application/json"), (String)"{\"error\": {\"code\": \"TooManyRequests\",\"innerError\": {\"code\": \"429\",\"date\": \"2020-08-18T12:51:51\",\"message\": \"Please retry after\",\"request-id\": \"94fb3b52-452a-4535-a601-69e0a90e3aa2\",\"status\": \"429\"},\"message\": \"Please retry again later.\"}}")).build();
        }
        return chain.proceed(request);
    }
}

