/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.tasks;

import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.graph.core.tasks.PageIteratorBuilder;
import com.microsoft.kiota.ApiException;
import com.microsoft.kiota.Compatibility;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class PageIterator<TEntity extends Parsable, TCollectionPage extends Parsable & AdditionalDataHolder> {
    private static final String NO_COLLECTION_PROPERTY_ERROR = "The Parsable does not contain a collection property.";
    private RequestAdapter requestAdapter;
    private TCollectionPage currentPage;
    private ParsableFactory<TCollectionPage> collectionPageFactory;
    private Queue<TEntity> pageItemQueue;
    private Function<TEntity, Boolean> processPageItemCallback;
    private UnaryOperator<RequestInformation> requestConfigurator;
    private String deltaLink;
    private String nextLink;
    private PageIteratorState state = PageIteratorState.NOT_STARTED;

    protected PageIterator() {
    }

    @Nullable
    public String getDeltaLink() {
        return this.deltaLink;
    }

    @Nullable
    public String getNextLink() {
        return this.nextLink;
    }

    @Nonnull
    public PageIteratorState getPageIteratorState() {
        return this.state;
    }

    protected void setRequestAdapter(@Nonnull RequestAdapter requestAdapter) {
        this.requestAdapter = Objects.requireNonNull(requestAdapter);
    }

    protected void setCollectionPageFactory(@Nonnull ParsableFactory<TCollectionPage> collectionPageFactory) {
        this.collectionPageFactory = Objects.requireNonNull(collectionPageFactory);
    }

    protected void setRequestConfigurator(@Nullable UnaryOperator<RequestInformation> requestConfigurator) {
        this.requestConfigurator = requestConfigurator;
    }

    protected void setCurrentPage(@Nonnull TCollectionPage currentPage) {
        this.currentPage = (Parsable)Objects.requireNonNull(currentPage);
    }

    protected void setProcessPageItemCallback(@Nonnull Function<TEntity, Boolean> processPageItemCallback) {
        this.processPageItemCallback = Objects.requireNonNull(processPageItemCallback);
    }

    protected void setPageItemQueue(@Nonnull Queue<TEntity> pageItemQueue) {
        this.pageItemQueue = Objects.requireNonNull(pageItemQueue);
    }

    private boolean intrapageIterate() throws ReflectiveOperationException {
        this.state = PageIteratorState.INTRAPAGE_ITERATION;
        while (!this.pageItemQueue.isEmpty()) {
            boolean shouldContinue = this.processPageItemCallback.apply((Parsable)this.pageItemQueue.remove());
            if (shouldContinue) continue;
            this.state = PageIteratorState.PAUSED;
            return false;
        }
        String extractedNextLink = PageIterator.extractNextLinkFromParsable(this.currentPage, null);
        if (!Compatibility.isBlank((String)extractedNextLink)) {
            this.nextLink = extractedNextLink;
            this.deltaLink = "";
            return true;
        }
        String extractedDeltaLink = PageIterator.extractNextLinkFromParsable(this.currentPage, "getOdataDeltaLink");
        if (!Compatibility.isBlank((String)extractedDeltaLink)) {
            this.deltaLink = extractedDeltaLink;
            this.state = PageIteratorState.DELTA;
        } else {
            this.state = PageIteratorState.COMPLETE;
        }
        this.nextLink = "";
        return false;
    }

    private void interpageIterate() throws ReflectiveOperationException {
        this.state = PageIteratorState.INTERPAGE_ITERATION;
        if (!Compatibility.isBlank((String)this.nextLink) || !Compatibility.isBlank((String)this.deltaLink)) {
            RequestInformation nextPageRequestInformation = new RequestInformation();
            nextPageRequestInformation.httpMethod = HttpMethod.GET;
            nextPageRequestInformation.urlTemplate = Compatibility.isBlank((String)this.nextLink) ? this.deltaLink : this.nextLink;
            nextPageRequestInformation = this.requestConfigurator == null ? nextPageRequestInformation : (RequestInformation)this.requestConfigurator.apply(nextPageRequestInformation);
            this.currentPage = Objects.requireNonNull(this.requestAdapter.send(nextPageRequestInformation, null, this.collectionPageFactory));
            List<TEntity> pageItems = PageIterator.extractEntityListFromParsable(this.currentPage);
            if (!pageItems.isEmpty()) {
                this.pageItemQueue.addAll(pageItems);
            }
        }
        if (!Compatibility.isBlank((String)this.nextLink) && this.nextLink.equals(PageIterator.extractNextLinkFromParsable(this.currentPage, null))) {
            throw new ApiException("Detected a nextLink loop. NextLink value: " + this.nextLink);
        }
    }

    public void iterate() throws ApiException, ReflectiveOperationException {
        if (this.state == PageIteratorState.DELTA) {
            this.interpageIterate();
        }
        boolean shouldContinueInterpageIteration = this.intrapageIterate();
        while (shouldContinueInterpageIteration) {
            this.interpageIterate();
            shouldContinueInterpageIteration = this.intrapageIterate();
        }
    }

    public void resume() throws ApiException, ReflectiveOperationException {
        this.iterate();
    }

    @Nonnull
    protected static <TEntity extends Parsable, TCollectionPage extends Parsable & AdditionalDataHolder> List<TEntity> extractEntityListFromParsable(@Nonnull TCollectionPage parsableCollection) throws IllegalAccessException, InvocationTargetException {
        try {
            return (List)parsableCollection.getClass().getDeclaredMethod("getValue", new Class[0]).invoke(parsableCollection, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalAccessException("NO_COLLECTION_PROPERTY_ERROR");
        }
    }

    private static <TCollectionPage extends Parsable & AdditionalDataHolder> String extractNextLinkFromParsable(@Nonnull TCollectionPage parsableCollection, @Nullable String getNextLinkMethodName) throws ReflectiveOperationException {
        Method nextLinkMethod;
        String nextLink;
        String methodName = getNextLinkMethodName == null ? "getOdataNextLink" : getNextLinkMethodName;
        Method[] methods = parsableCollection.getClass().getMethods();
        Optional<Method> nextLinkOptional = Arrays.stream(methods).filter(m -> m.getName().equals(methodName)).findFirst();
        if (nextLinkOptional.isPresent() && !Compatibility.isBlank((String)(nextLink = (String)(nextLinkMethod = nextLinkOptional.get()).invoke(parsableCollection, new Object[0])))) {
            return nextLink;
        }
        nextLink = (String)((AdditionalDataHolder)parsableCollection).getAdditionalData().get("@odata.nextLink");
        return nextLink == null ? "" : nextLink;
    }

    public static enum PageIteratorState {
        NOT_STARTED,
        PAUSED,
        INTERPAGE_ITERATION,
        INTRAPAGE_ITERATION,
        DELTA,
        COMPLETE;

    }

    public static class Builder<TEntity extends Parsable, TCollectionPage extends Parsable & AdditionalDataHolder>
    implements PageIteratorBuilder<TEntity, TCollectionPage> {
        private RequestAdapter requestAdapter;
        private TCollectionPage currentPage;
        private ParsableFactory<TCollectionPage> collectionPageFactory;
        private UnaryOperator<RequestInformation> requestConfigurator;
        private Function<TEntity, Boolean> processPageItemCallback;

        private RequestAdapter getRequestAdapter() {
            return this.requestAdapter;
        }

        private TCollectionPage getCollectionPage() {
            return this.currentPage;
        }

        private ParsableFactory<TCollectionPage> getCollectionPageFactory() {
            return this.collectionPageFactory;
        }

        private UnaryOperator<RequestInformation> getRequestConfigurator() {
            return this.requestConfigurator;
        }

        private Function<TEntity, Boolean> getProcessPageItemCallback() {
            return this.processPageItemCallback;
        }

        @Override
        @Nonnull
        public Builder<TEntity, TCollectionPage> client(@Nonnull IBaseClient client) {
            Objects.requireNonNull(client);
            return this.requestAdapter(client.getRequestAdapter());
        }

        @Override
        @Nonnull
        public Builder<TEntity, TCollectionPage> requestAdapter(@Nonnull RequestAdapter requestAdapter) {
            this.requestAdapter = Objects.requireNonNull(requestAdapter);
            return this;
        }

        @Override
        @Nonnull
        public Builder<TEntity, TCollectionPage> collectionPage(@Nonnull TCollectionPage collectionPage) {
            this.currentPage = (Parsable)Objects.requireNonNull(collectionPage);
            return this;
        }

        @Override
        @Nonnull
        public Builder<TEntity, TCollectionPage> collectionPageFactory(@Nonnull ParsableFactory<TCollectionPage> collectionPageFactory) {
            this.collectionPageFactory = Objects.requireNonNull(collectionPageFactory);
            return this;
        }

        @Override
        @Nonnull
        public Builder<TEntity, TCollectionPage> requestConfigurator(@Nonnull UnaryOperator<RequestInformation> requestConfigurator) {
            this.requestConfigurator = Objects.requireNonNull(requestConfigurator);
            return this;
        }

        @Nonnull
        public Builder<TEntity, TCollectionPage> processPageItemCallback(@Nonnull Function<TEntity, Boolean> processPageItemCallback) {
            this.processPageItemCallback = Objects.requireNonNull(processPageItemCallback);
            return this;
        }

        @Nonnull
        private PageIterator<TEntity, TCollectionPage> build(@Nonnull PageIterator<TEntity, TCollectionPage> instance) throws InvocationTargetException, IllegalAccessException {
            Objects.requireNonNull(instance);
            if (!this.currentPage.getFieldDeserializers().containsKey("value")) {
                throw new IllegalArgumentException(PageIterator.NO_COLLECTION_PROPERTY_ERROR);
            }
            instance.setRequestAdapter(Objects.requireNonNull(this.getRequestAdapter()));
            instance.setCurrentPage((Parsable)Objects.requireNonNull(this.getCollectionPage()));
            instance.setCollectionPageFactory(Objects.requireNonNull(this.getCollectionPageFactory()));
            instance.setRequestConfigurator(this.getRequestConfigurator());
            instance.setProcessPageItemCallback(Objects.requireNonNull(this.getProcessPageItemCallback()));
            LinkedList currentCollection = new LinkedList(PageIterator.extractEntityListFromParsable(this.getCollectionPage()));
            instance.setPageItemQueue(currentCollection);
            return instance;
        }

        @Override
        @Nonnull
        public PageIterator<TEntity, TCollectionPage> build() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
            return this.build(new PageIterator());
        }
    }
}

