/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.concurrency;

import com.microsoft.graph.http.DefaultHttpProvider;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.http.IConnection;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.http.IStatefulResponseHandler;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.models.extensions.UploadSession;
import com.microsoft.graph.requests.extensions.ChunkedUploadResult;
import com.microsoft.graph.serializer.ISerializer;
import java.io.BufferedInputStream;
import java.io.InputStream;

public class ChunkedUploadResponseHandler<UploadType>
implements IStatefulResponseHandler<ChunkedUploadResult, UploadType> {
    private final Class<UploadType> deserializeTypeClass;

    public ChunkedUploadResponseHandler(Class<UploadType> uploadType) {
        this.deserializeTypeClass = uploadType;
    }

    @Override
    public void configConnection(IConnection connection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkedUploadResult<UploadType> generateResult(IHttpRequest request, IConnection connection, ISerializer serializer, ILogger logger) throws Exception {
        try (InputStream in = null;){
            if (connection.getResponseCode() == 202) {
                logger.logDebug("Chunk bytes has been accepted by the server.");
                in = new BufferedInputStream(connection.getInputStream());
                UploadSession session = serializer.deserializeObject(DefaultHttpProvider.streamToString(in), UploadSession.class);
                ChunkedUploadResult chunkedUploadResult = new ChunkedUploadResult(session);
                return chunkedUploadResult;
            }
            if (connection.getResponseCode() == 201 || connection.getResponseCode() == 200) {
                logger.logDebug("Upload session is completed, uploaded item returned.");
                in = new BufferedInputStream(connection.getInputStream());
                String rawJson = DefaultHttpProvider.streamToString(in);
                UploadType uploadedItem = serializer.deserializeObject(rawJson, this.deserializeTypeClass);
                ChunkedUploadResult<UploadType> chunkedUploadResult = new ChunkedUploadResult<UploadType>(uploadedItem);
                return chunkedUploadResult;
            }
            if (connection.getResponseCode() >= 400) {
                logger.logDebug("Receiving error during upload, see detail on result error");
                ChunkedUploadResult chunkedUploadResult = new ChunkedUploadResult(GraphServiceException.createFromConnection(request, null, serializer, connection, logger));
                return chunkedUploadResult;
            }
        }
        return null;
    }
}

