/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.extensions.MediaConfig;
import com.microsoft.graph.models.generated.Modality;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.CallAnswerRequest;
import com.microsoft.graph.requests.extensions.ICallAnswerRequest;
import com.microsoft.graph.requests.extensions.ICallAnswerRequestBuilder;
import java.util.List;

public class CallAnswerRequestBuilder
extends BaseActionRequestBuilder
implements ICallAnswerRequestBuilder {
    public CallAnswerRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, String callbackUri, MediaConfig mediaConfig, List<Modality> acceptedModalities) {
        super(requestUrl, client, requestOptions);
        this.bodyParams.put("callbackUri", callbackUri);
        this.bodyParams.put("mediaConfig", mediaConfig);
        this.bodyParams.put("acceptedModalities", acceptedModalities);
    }

    @Override
    public ICallAnswerRequest buildRequest() {
        return this.buildRequest(this.getOptions());
    }

    @Override
    public ICallAnswerRequest buildRequest(List<? extends Option> requestOptions) {
        CallAnswerRequest request = new CallAnswerRequest(this.getRequestUrl(), this.getClient(), requestOptions);
        if (this.hasParameter("callbackUri")) {
            request.body.callbackUri = (String)this.getParameter("callbackUri");
        }
        if (this.hasParameter("mediaConfig")) {
            request.body.mediaConfig = (MediaConfig)this.getParameter("mediaConfig");
        }
        if (this.hasParameter("acceptedModalities")) {
            request.body.acceptedModalities = (List)this.getParameter("acceptedModalities");
        }
        return request;
    }
}

