// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.CalendarRoleType;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Calendar Allowed Calendar Sharing Roles Parameter Set.
 */
public class CalendarAllowedCalendarSharingRolesParameterSet {
    /**
     * The user.
     * 
     */
    @SerializedName(value = "user", alternate = {"User"})
    @Expose
	@Nullable
    public String user;


    /**
     * Instiaciates a new CalendarAllowedCalendarSharingRolesParameterSet
     */
    public CalendarAllowedCalendarSharingRolesParameterSet() {}
    /**
     * Instiaciates a new CalendarAllowedCalendarSharingRolesParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected CalendarAllowedCalendarSharingRolesParameterSet(@Nonnull final CalendarAllowedCalendarSharingRolesParameterSetBuilder builder) {
        this.user = builder.user;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static CalendarAllowedCalendarSharingRolesParameterSetBuilder newBuilder() {
        return new CalendarAllowedCalendarSharingRolesParameterSetBuilder();
    }
    /**
     * Fluent builder for the CalendarAllowedCalendarSharingRolesParameterSet
     */
    public static final class CalendarAllowedCalendarSharingRolesParameterSetBuilder {
        /**
         * The user parameter value
         */
        @Nullable
        protected String user;
        /**
         * Sets the User
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CalendarAllowedCalendarSharingRolesParameterSetBuilder withUser(@Nullable final String val) {
            this.user = val;
            return this;
        }
        /**
         * Instanciates a new CalendarAllowedCalendarSharingRolesParameterSetBuilder
         */
        @Nullable
        protected CalendarAllowedCalendarSharingRolesParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public CalendarAllowedCalendarSharingRolesParameterSet build() {
            return new CalendarAllowedCalendarSharingRolesParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.user != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("user", user));
        }
        return result;
    }
}
