// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ChangeNotification;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Change Notification Collection.
 */
public class ChangeNotificationCollection implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Validation Tokens.
     * Contains an array of JWT tokens generated by Microsoft Graph for the application to validate the origin of the notifications. Microsoft Graph generates a single token for each distinct app and tenant pair for an item if it exists in the value array. Keep in mind that notifications can contain a mix of items for various apps and tenants that subscribed using the same notification URL. Only provided for change notifications with resource data Optional.
     */
    @SerializedName(value = "validationTokens", alternate = {"ValidationTokens"})
    @Expose
	@Nullable
    public java.util.List<String> validationTokens;

    /**
     * The Value.
     * The set of notifications being sent to the notification URL. Required.
     */
    @SerializedName(value = "value", alternate = {"Value"})
    @Expose
	@Nullable
    public java.util.List<ChangeNotification> value;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
