// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Object Check Member Objects Parameter Set.
 */
public class DirectoryObjectCheckMemberObjectsParameterSet {
    /**
     * The ids.
     * 
     */
    @SerializedName(value = "ids", alternate = {"Ids"})
    @Expose
	@Nullable
    public java.util.List<String> ids;


    /**
     * Instiaciates a new DirectoryObjectCheckMemberObjectsParameterSet
     */
    public DirectoryObjectCheckMemberObjectsParameterSet() {}
    /**
     * Instiaciates a new DirectoryObjectCheckMemberObjectsParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected DirectoryObjectCheckMemberObjectsParameterSet(@Nonnull final DirectoryObjectCheckMemberObjectsParameterSetBuilder builder) {
        this.ids = builder.ids;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static DirectoryObjectCheckMemberObjectsParameterSetBuilder newBuilder() {
        return new DirectoryObjectCheckMemberObjectsParameterSetBuilder();
    }
    /**
     * Fluent builder for the DirectoryObjectCheckMemberObjectsParameterSet
     */
    public static final class DirectoryObjectCheckMemberObjectsParameterSetBuilder {
        /**
         * The ids parameter value
         */
        @Nullable
        protected java.util.List<String> ids;
        /**
         * Sets the Ids
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DirectoryObjectCheckMemberObjectsParameterSetBuilder withIds(@Nullable final java.util.List<String> val) {
            this.ids = val;
            return this;
        }
        /**
         * Instanciates a new DirectoryObjectCheckMemberObjectsParameterSetBuilder
         */
        @Nullable
        protected DirectoryObjectCheckMemberObjectsParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public DirectoryObjectCheckMemberObjectsParameterSet build() {
            return new DirectoryObjectCheckMemberObjectsParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.ids != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("ids", ids));
        }
        return result;
    }
}
