// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.AttendeeBase;
import com.microsoft.graph.models.LocationConstraint;
import com.microsoft.graph.models.TimeConstraint;
import com.microsoft.graph.models.MeetingTimeSuggestionsResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Find Meeting Times Parameter Set.
 */
public class UserFindMeetingTimesParameterSet {
    /**
     * The attendees.
     * 
     */
    @SerializedName(value = "attendees", alternate = {"Attendees"})
    @Expose
	@Nullable
    public java.util.List<AttendeeBase> attendees;

    /**
     * The location Constraint.
     * 
     */
    @SerializedName(value = "locationConstraint", alternate = {"LocationConstraint"})
    @Expose
	@Nullable
    public LocationConstraint locationConstraint;

    /**
     * The time Constraint.
     * 
     */
    @SerializedName(value = "timeConstraint", alternate = {"TimeConstraint"})
    @Expose
	@Nullable
    public TimeConstraint timeConstraint;

    /**
     * The meeting Duration.
     * 
     */
    @SerializedName(value = "meetingDuration", alternate = {"MeetingDuration"})
    @Expose
	@Nullable
    public javax.xml.datatype.Duration meetingDuration;

    /**
     * The max Candidates.
     * 
     */
    @SerializedName(value = "maxCandidates", alternate = {"MaxCandidates"})
    @Expose
	@Nullable
    public Integer maxCandidates;

    /**
     * The is Organizer Optional.
     * 
     */
    @SerializedName(value = "isOrganizerOptional", alternate = {"IsOrganizerOptional"})
    @Expose
	@Nullable
    public Boolean isOrganizerOptional;

    /**
     * The return Suggestion Reasons.
     * 
     */
    @SerializedName(value = "returnSuggestionReasons", alternate = {"ReturnSuggestionReasons"})
    @Expose
	@Nullable
    public Boolean returnSuggestionReasons;

    /**
     * The minimum Attendee Percentage.
     * 
     */
    @SerializedName(value = "minimumAttendeePercentage", alternate = {"MinimumAttendeePercentage"})
    @Expose
	@Nullable
    public Double minimumAttendeePercentage;


    /**
     * Instiaciates a new UserFindMeetingTimesParameterSet
     */
    public UserFindMeetingTimesParameterSet() {}
    /**
     * Instiaciates a new UserFindMeetingTimesParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected UserFindMeetingTimesParameterSet(@Nonnull final UserFindMeetingTimesParameterSetBuilder builder) {
        this.attendees = builder.attendees;
        this.locationConstraint = builder.locationConstraint;
        this.timeConstraint = builder.timeConstraint;
        this.meetingDuration = builder.meetingDuration;
        this.maxCandidates = builder.maxCandidates;
        this.isOrganizerOptional = builder.isOrganizerOptional;
        this.returnSuggestionReasons = builder.returnSuggestionReasons;
        this.minimumAttendeePercentage = builder.minimumAttendeePercentage;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static UserFindMeetingTimesParameterSetBuilder newBuilder() {
        return new UserFindMeetingTimesParameterSetBuilder();
    }
    /**
     * Fluent builder for the UserFindMeetingTimesParameterSet
     */
    public static final class UserFindMeetingTimesParameterSetBuilder {
        /**
         * The attendees parameter value
         */
        @Nullable
        protected java.util.List<AttendeeBase> attendees;
        /**
         * Sets the Attendees
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public UserFindMeetingTimesParameterSetBuilder withAttendees(@Nullable final java.util.List<AttendeeBase> val) {
            this.attendees = val;
            return this;
        }
        /**
         * The locationConstraint parameter value
         */
        @Nullable
        protected LocationConstraint locationConstraint;
        /**
         * Sets the LocationConstraint
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public UserFindMeetingTimesParameterSetBuilder withLocationConstraint(@Nullable final LocationConstraint val) {
            this.locationConstraint = val;
            return this;
        }
        /**
         * The timeConstraint parameter value
         */
        @Nullable
        protected TimeConstraint timeConstraint;
        /**
         * Sets the TimeConstraint
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public UserFindMeetingTimesParameterSetBuilder withTimeConstraint(@Nullable final TimeConstraint val) {
            this.timeConstraint = val;
            return this;
        }
        /**
         * The meetingDuration parameter value
         */
        @Nullable
        protected javax.xml.datatype.Duration meetingDuration;
        /**
         * Sets the MeetingDuration
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public UserFindMeetingTimesParameterSetBuilder withMeetingDuration(@Nullable final javax.xml.datatype.Duration val) {
            this.meetingDuration = val;
            return this;
        }
        /**
         * The maxCandidates parameter value
         */
        @Nullable
        protected Integer maxCandidates;
        /**
         * Sets the MaxCandidates
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public UserFindMeetingTimesParameterSetBuilder withMaxCandidates(@Nullable final Integer val) {
            this.maxCandidates = val;
            return this;
        }
        /**
         * The isOrganizerOptional parameter value
         */
        @Nullable
        protected Boolean isOrganizerOptional;
        /**
         * Sets the IsOrganizerOptional
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public UserFindMeetingTimesParameterSetBuilder withIsOrganizerOptional(@Nullable final Boolean val) {
            this.isOrganizerOptional = val;
            return this;
        }
        /**
         * The returnSuggestionReasons parameter value
         */
        @Nullable
        protected Boolean returnSuggestionReasons;
        /**
         * Sets the ReturnSuggestionReasons
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public UserFindMeetingTimesParameterSetBuilder withReturnSuggestionReasons(@Nullable final Boolean val) {
            this.returnSuggestionReasons = val;
            return this;
        }
        /**
         * The minimumAttendeePercentage parameter value
         */
        @Nullable
        protected Double minimumAttendeePercentage;
        /**
         * Sets the MinimumAttendeePercentage
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public UserFindMeetingTimesParameterSetBuilder withMinimumAttendeePercentage(@Nullable final Double val) {
            this.minimumAttendeePercentage = val;
            return this;
        }
        /**
         * Instanciates a new UserFindMeetingTimesParameterSetBuilder
         */
        @Nullable
        protected UserFindMeetingTimesParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public UserFindMeetingTimesParameterSet build() {
            return new UserFindMeetingTimesParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.attendees != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("attendees", attendees));
        }
        if(this.locationConstraint != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("locationConstraint", locationConstraint));
        }
        if(this.timeConstraint != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("timeConstraint", timeConstraint));
        }
        if(this.meetingDuration != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("meetingDuration", meetingDuration));
        }
        if(this.maxCandidates != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("maxCandidates", maxCandidates));
        }
        if(this.isOrganizerOptional != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("isOrganizerOptional", isOrganizerOptional));
        }
        if(this.returnSuggestionReasons != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("returnSuggestionReasons", returnSuggestionReasons));
        }
        if(this.minimumAttendeePercentage != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("minimumAttendeePercentage", minimumAttendeePercentage));
        }
        return result;
    }
}
