// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EmailAuthenticationMethodConfiguration;
import com.microsoft.graph.requests.AuthenticationMethodTargetCollectionRequestBuilder;
import com.microsoft.graph.requests.AuthenticationMethodTargetRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Email Authentication Method Configuration Request.
 */
public class EmailAuthenticationMethodConfigurationRequest extends BaseRequest<EmailAuthenticationMethodConfiguration> {
	
    /**
     * The request for the EmailAuthenticationMethodConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EmailAuthenticationMethodConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EmailAuthenticationMethodConfiguration.class);
    }

    /**
     * Gets the EmailAuthenticationMethodConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmailAuthenticationMethodConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EmailAuthenticationMethodConfiguration from the service
     *
     * @return the EmailAuthenticationMethodConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmailAuthenticationMethodConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmailAuthenticationMethodConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EmailAuthenticationMethodConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EmailAuthenticationMethodConfiguration with a source
     *
     * @param sourceEmailAuthenticationMethodConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmailAuthenticationMethodConfiguration> patchAsync(@Nonnull final EmailAuthenticationMethodConfiguration sourceEmailAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceEmailAuthenticationMethodConfiguration);
    }

    /**
     * Patches this EmailAuthenticationMethodConfiguration with a source
     *
     * @param sourceEmailAuthenticationMethodConfiguration the source object with updates
     * @return the updated EmailAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmailAuthenticationMethodConfiguration patch(@Nonnull final EmailAuthenticationMethodConfiguration sourceEmailAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceEmailAuthenticationMethodConfiguration);
    }

    /**
     * Creates a EmailAuthenticationMethodConfiguration with a new object
     *
     * @param newEmailAuthenticationMethodConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmailAuthenticationMethodConfiguration> postAsync(@Nonnull final EmailAuthenticationMethodConfiguration newEmailAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.POST, newEmailAuthenticationMethodConfiguration);
    }

    /**
     * Creates a EmailAuthenticationMethodConfiguration with a new object
     *
     * @param newEmailAuthenticationMethodConfiguration the new object to create
     * @return the created EmailAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmailAuthenticationMethodConfiguration post(@Nonnull final EmailAuthenticationMethodConfiguration newEmailAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.POST, newEmailAuthenticationMethodConfiguration);
    }

    /**
     * Creates a EmailAuthenticationMethodConfiguration with a new object
     *
     * @param newEmailAuthenticationMethodConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmailAuthenticationMethodConfiguration> putAsync(@Nonnull final EmailAuthenticationMethodConfiguration newEmailAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PUT, newEmailAuthenticationMethodConfiguration);
    }

    /**
     * Creates a EmailAuthenticationMethodConfiguration with a new object
     *
     * @param newEmailAuthenticationMethodConfiguration the object to create/update
     * @return the created EmailAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmailAuthenticationMethodConfiguration put(@Nonnull final EmailAuthenticationMethodConfiguration newEmailAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newEmailAuthenticationMethodConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EmailAuthenticationMethodConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EmailAuthenticationMethodConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

