// Template Source: BaseEntityCollectionWithReferencesRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.B2xIdentityUserFlow;
import com.microsoft.graph.models.IdentityProvider;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.BaseCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Provider Collection With References Request Builder.
 */
public class IdentityProviderCollectionWithReferencesRequestBuilder extends BaseCollectionWithReferencesRequestBuilder<IdentityProvider, IdentityProviderWithReferenceRequest, IdentityProviderReferenceRequestBuilder, IdentityProviderWithReferenceRequestBuilder, IdentityProviderCollectionResponse, IdentityProviderCollectionWithReferencesPage, IdentityProviderCollectionReferenceRequest, IdentityProviderCollectionReferenceRequestBuilder> {

    /**
     * The request builder for this collection of B2xIdentityUserFlow
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IdentityProviderCollectionWithReferencesRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityProviderReferenceRequestBuilder.class, IdentityProviderCollectionReferenceRequest.class, IdentityProviderCollectionReferenceRequestBuilder.class);
    }
}
