// Template Source: BaseMethodCollectionPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TimeZoneInformation;
import com.microsoft.graph.models.TimeZoneStandard;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.requests.OutlookUserSupportedTimeZonesCollectionRequestBuilder;
import com.microsoft.graph.requests.OutlookUserSupportedTimeZonesCollectionPage;
import com.microsoft.graph.requests.OutlookUserSupportedTimeZonesCollectionResponse;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Outlook User Supported Time Zones Collection Page.
 */
public class OutlookUserSupportedTimeZonesCollectionPage extends BaseCollectionPage<TimeZoneInformation, OutlookUserSupportedTimeZonesCollectionRequestBuilder> {

    /**
     * A collection page for TimeZoneInformation.
     *
     * @param response The serialized OutlookUserSupportedTimeZonesCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public OutlookUserSupportedTimeZonesCollectionPage(@Nonnull final OutlookUserSupportedTimeZonesCollectionResponse response, @Nonnull final OutlookUserSupportedTimeZonesCollectionRequestBuilder builder) {
       super(response, builder);
    }

	/**
     * Creates the collection page for OutlookUserSupportedTimeZones
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public OutlookUserSupportedTimeZonesCollectionPage(@Nonnull final java.util.List<TimeZoneInformation> pageContents, @Nullable final OutlookUserSupportedTimeZonesCollectionRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
