// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ResourceOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Resource Operation Request.
 */
public class ResourceOperationRequest extends BaseRequest<ResourceOperation> {
	
    /**
     * The request for the ResourceOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ResourceOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ResourceOperation.class);
    }

    /**
     * Gets the ResourceOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ResourceOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ResourceOperation from the service
     *
     * @return the ResourceOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ResourceOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ResourceOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ResourceOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ResourceOperation with a source
     *
     * @param sourceResourceOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ResourceOperation> patchAsync(@Nonnull final ResourceOperation sourceResourceOperation) {
        return sendAsync(HttpMethod.PATCH, sourceResourceOperation);
    }

    /**
     * Patches this ResourceOperation with a source
     *
     * @param sourceResourceOperation the source object with updates
     * @return the updated ResourceOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ResourceOperation patch(@Nonnull final ResourceOperation sourceResourceOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceResourceOperation);
    }

    /**
     * Creates a ResourceOperation with a new object
     *
     * @param newResourceOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ResourceOperation> postAsync(@Nonnull final ResourceOperation newResourceOperation) {
        return sendAsync(HttpMethod.POST, newResourceOperation);
    }

    /**
     * Creates a ResourceOperation with a new object
     *
     * @param newResourceOperation the new object to create
     * @return the created ResourceOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ResourceOperation post(@Nonnull final ResourceOperation newResourceOperation) throws ClientException {
        return send(HttpMethod.POST, newResourceOperation);
    }

    /**
     * Creates a ResourceOperation with a new object
     *
     * @param newResourceOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ResourceOperation> putAsync(@Nonnull final ResourceOperation newResourceOperation) {
        return sendAsync(HttpMethod.PUT, newResourceOperation);
    }

    /**
     * Creates a ResourceOperation with a new object
     *
     * @param newResourceOperation the object to create/update
     * @return the created ResourceOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ResourceOperation put(@Nonnull final ResourceOperation newResourceOperation) throws ClientException {
        return send(HttpMethod.PUT, newResourceOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ResourceOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ResourceOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

