/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DriveItemRequest
extends BaseRequest<DriveItem> {
    public DriveItemRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveItem.class);
    }

    @Nonnull
    public CompletableFuture<DriveItem> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public DriveItem get() throws ClientException {
        return (DriveItem)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<DriveItem> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public DriveItem delete() throws ClientException {
        return (DriveItem)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<DriveItem> patchAsync(@Nonnull DriveItem sourceDriveItem) {
        return this.sendAsync(HttpMethod.PATCH, sourceDriveItem);
    }

    @Nullable
    public DriveItem patch(@Nonnull DriveItem sourceDriveItem) throws ClientException {
        return (DriveItem)this.send(HttpMethod.PATCH, sourceDriveItem);
    }

    @Nonnull
    public CompletableFuture<DriveItem> postAsync(@Nonnull DriveItem newDriveItem) {
        return this.sendAsync(HttpMethod.POST, newDriveItem);
    }

    @Nullable
    public DriveItem post(@Nonnull DriveItem newDriveItem) throws ClientException {
        return (DriveItem)this.send(HttpMethod.POST, newDriveItem);
    }

    @Nonnull
    public CompletableFuture<DriveItem> putAsync(@Nonnull DriveItem newDriveItem) {
        return this.sendAsync(HttpMethod.PUT, newDriveItem);
    }

    @Nullable
    public DriveItem put(@Nonnull DriveItem newDriveItem) throws ClientException {
        return (DriveItem)this.send(HttpMethod.PUT, newDriveItem);
    }

    @Nonnull
    public DriveItemRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DriveItemRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

