/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.Event;
import com.microsoft.graph.models.EventAcceptParameterSet;
import com.microsoft.graph.models.EventCancelParameterSet;
import com.microsoft.graph.models.EventDeclineParameterSet;
import com.microsoft.graph.models.EventForwardParameterSet;
import com.microsoft.graph.models.EventSnoozeReminderParameterSet;
import com.microsoft.graph.models.EventTentativelyAcceptParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.AttachmentCollectionRequestBuilder;
import com.microsoft.graph.requests.AttachmentRequestBuilder;
import com.microsoft.graph.requests.CalendarRequestBuilder;
import com.microsoft.graph.requests.EventAcceptRequestBuilder;
import com.microsoft.graph.requests.EventCancelRequestBuilder;
import com.microsoft.graph.requests.EventCollectionRequestBuilder;
import com.microsoft.graph.requests.EventDeclineRequestBuilder;
import com.microsoft.graph.requests.EventDismissReminderRequestBuilder;
import com.microsoft.graph.requests.EventForwardRequestBuilder;
import com.microsoft.graph.requests.EventRequest;
import com.microsoft.graph.requests.EventSnoozeReminderRequestBuilder;
import com.microsoft.graph.requests.EventTentativelyAcceptRequestBuilder;
import com.microsoft.graph.requests.ExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.ExtensionRequestBuilder;
import com.microsoft.graph.requests.MultiValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.MultiValueLegacyExtendedPropertyRequestBuilder;
import com.microsoft.graph.requests.SingleValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.SingleValueLegacyExtendedPropertyRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EventRequestBuilder
extends BaseRequestBuilder<Event> {
    public EventRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public EventRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public EventRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new EventRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public AttachmentCollectionRequestBuilder attachments() {
        return new AttachmentCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("attachments"), this.getClient(), null);
    }

    @Nonnull
    public AttachmentRequestBuilder attachments(@Nonnull String id) {
        return new AttachmentRequestBuilder(this.getRequestUrlWithAdditionalSegment("attachments") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public CalendarRequestBuilder calendar() {
        return new CalendarRequestBuilder(this.getRequestUrlWithAdditionalSegment("calendar"), this.getClient(), null);
    }

    @Nonnull
    public ExtensionCollectionRequestBuilder extensions() {
        return new ExtensionCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("extensions"), this.getClient(), null);
    }

    @Nonnull
    public ExtensionRequestBuilder extensions(@Nonnull String id) {
        return new ExtensionRequestBuilder(this.getRequestUrlWithAdditionalSegment("extensions") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public EventCollectionRequestBuilder instances() {
        return new EventCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("instances"), this.getClient(), null);
    }

    @Nonnull
    public EventRequestBuilder instances(@Nonnull String id) {
        return new EventRequestBuilder(this.getRequestUrlWithAdditionalSegment("instances") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public MultiValueLegacyExtendedPropertyCollectionRequestBuilder multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("multiValueExtendedProperties"), this.getClient(), null);
    }

    @Nonnull
    public MultiValueLegacyExtendedPropertyRequestBuilder multiValueExtendedProperties(@Nonnull String id) {
        return new MultiValueLegacyExtendedPropertyRequestBuilder(this.getRequestUrlWithAdditionalSegment("multiValueExtendedProperties") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public SingleValueLegacyExtendedPropertyCollectionRequestBuilder singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("singleValueExtendedProperties"), this.getClient(), null);
    }

    @Nonnull
    public SingleValueLegacyExtendedPropertyRequestBuilder singleValueExtendedProperties(@Nonnull String id) {
        return new SingleValueLegacyExtendedPropertyRequestBuilder(this.getRequestUrlWithAdditionalSegment("singleValueExtendedProperties") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public EventAcceptRequestBuilder accept(@Nonnull EventAcceptParameterSet parameters) {
        return new EventAcceptRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.accept"), this.getClient(), null, parameters);
    }

    @Nonnull
    public EventCancelRequestBuilder cancel(@Nonnull EventCancelParameterSet parameters) {
        return new EventCancelRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.cancel"), this.getClient(), null, parameters);
    }

    @Nonnull
    public EventDeclineRequestBuilder decline(@Nonnull EventDeclineParameterSet parameters) {
        return new EventDeclineRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.decline"), this.getClient(), null, parameters);
    }

    @Nonnull
    public EventDismissReminderRequestBuilder dismissReminder() {
        return new EventDismissReminderRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.dismissReminder"), this.getClient(), null);
    }

    @Nonnull
    public EventForwardRequestBuilder forward(@Nonnull EventForwardParameterSet parameters) {
        return new EventForwardRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.forward"), this.getClient(), null, parameters);
    }

    @Nonnull
    public EventSnoozeReminderRequestBuilder snoozeReminder(@Nonnull EventSnoozeReminderParameterSet parameters) {
        return new EventSnoozeReminderRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.snoozeReminder"), this.getClient(), null, parameters);
    }

    @Nonnull
    public EventTentativelyAcceptRequestBuilder tentativelyAccept(@Nonnull EventTentativelyAcceptParameterSet parameters) {
        return new EventTentativelyAcceptRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.tentativelyAccept"), this.getClient(), null, parameters);
    }
}

