/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.NamedLocation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.NamedLocationCollectionPage;
import com.microsoft.graph.requests.NamedLocationCollectionRequestBuilder;
import com.microsoft.graph.requests.NamedLocationCollectionResponse;
import com.microsoft.graph.requests.NamedLocationRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NamedLocationCollectionRequest
extends BaseEntityCollectionRequest<NamedLocation, NamedLocationCollectionResponse, NamedLocationCollectionPage> {
    public NamedLocationCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, NamedLocationCollectionResponse.class, NamedLocationCollectionPage.class, NamedLocationCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<NamedLocation> postAsync(@Nonnull NamedLocation newNamedLocation) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new NamedLocationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newNamedLocation);
    }

    @Nonnull
    public NamedLocation post(@Nonnull NamedLocation newNamedLocation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new NamedLocationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newNamedLocation);
    }

    @Nonnull
    public NamedLocationCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public NamedLocationCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public NamedLocationCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public NamedLocationCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public NamedLocationCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public NamedLocationCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public NamedLocationCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public NamedLocationCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public NamedLocationCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

