/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.SynchronizationJob;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.SynchronizationJobCollectionPage;
import com.microsoft.graph.requests.SynchronizationJobCollectionRequestBuilder;
import com.microsoft.graph.requests.SynchronizationJobCollectionResponse;
import com.microsoft.graph.requests.SynchronizationJobRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SynchronizationJobCollectionRequest
extends BaseEntityCollectionRequest<SynchronizationJob, SynchronizationJobCollectionResponse, SynchronizationJobCollectionPage> {
    public SynchronizationJobCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SynchronizationJobCollectionResponse.class, SynchronizationJobCollectionPage.class, SynchronizationJobCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<SynchronizationJob> postAsync(@Nonnull SynchronizationJob newSynchronizationJob) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SynchronizationJobRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newSynchronizationJob);
    }

    @Nonnull
    public SynchronizationJob post(@Nonnull SynchronizationJob newSynchronizationJob) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SynchronizationJobRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSynchronizationJob);
    }

    @Nonnull
    public SynchronizationJobCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public SynchronizationJobCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public SynchronizationJobCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public SynchronizationJobCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SynchronizationJobCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public SynchronizationJobCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public SynchronizationJobCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public SynchronizationJobCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public SynchronizationJobCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

